// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi2ring.cc,v 1.2 2003-01-30 17:19:25 cecile Exp $

#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"
#include "toi2ring.h"
// La valeur "Pi" doit etre celle de smathconst.h a cause du test sur theta
#include "smathconst.h"

////////////////////////////////////////////////////////////////////////
Toi2RING::Toi2RING(long n)
  :totnscount(0), nRings(0)
{
  setNSamples(n);
}

Toi2RING::~Toi2RING()
{
}


////////////////////////////////////////////////////////////////////////
void Toi2RING::Print(::ostream & os)
{
}

////////////////////////////////////////////////////////////////////////
void Toi2RING::init() {
  cout << "Toi2RING::init" << endl;
  declareInput("Theta");     // input  index 0
  declareInput("Phi");     // input  index 0
  declareInput("Phase");     // input  index 0
  declareInput("Value");     // input  index 1
  declareOutput("CircTheta");   // output index 0
  declareOutput("CircPhi");   // output index 0
  declareOutput("Rvalue");   // output index 0
  //  declareOutput("WRvalue");   // output index 1
}

////////////////////////////////////////////////////////////////////////
void Toi2RING::run() {

long snb = getMinIn();
long sne = getMaxIn();
if(snb>sne) {
  cout<<"Toi2RING::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
  throw ParmError("Toi2RING::run() - Bad sample interval");
}

//---------------------------------------------------------
try {


uint_4 mSnRead=0, mSnFilled=0, BadCoorRange=0;
 int_8 Nrings=0,i;
 
 double phi_prec=-1.;
 double* r = new double[Nsamples];
 double* wr = new double[Nsamples];
 for(i=0;i<Nsamples;i++) {
   wr[i]=0;
   r[i]=0;
 }

 
 
for(int k=snb;k<=sne;k++) {

  uint_8 flg = 0;
  double ctheta = getData(0,k);
  double cphi = getData(1,k);
  double phi = getData(2,k);
  double val = getData(3,k);
  mSnRead++;

  i=(int)(phi*Nsamples/360.);
  r[i]+= val;
  wr[i]++;

  cout << phi << " " << phi_prec << " " << Nrings <<endl;
  
  if(phi < phi_prec){
    
    putData(0,Nrings,ctheta);
    putData(1,Nrings,cphi);

    for(i=0;i<Nsamples;i++) {
      if(wr[i] == 0) r[i] = -999999.;
      cout << i << " " << Nrings << " " << Nsamples << " " << ctheta << " " << cphi << " " << r[i]<< endl;
      putData(2,Nrings*Nsamples+i,r[i]);
      //      putData(1,Nrings*Nsamples+i,wr[i]);
      wr[i]=0;
      r[i]=0.;
    }
    
    Nrings++;
  }
  

  phi_prec=phi;
  totnscount++;
}

cout<<"RING2Toi::run: Samples Read "<<mSnRead
    <<" Filled "<<mSnFilled
    <<" BadCoorRange="<<BadCoorRange<<endl;

//---------------------------------------------------------
} catch (PException & exc) {
  cout<<"Toi2RING: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}

return;                                                                            
}
