//#define TOISEQBUFFERED

#include <unistd.h>
#include "toi.h"
#include "cgt.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitsringwtr.h"
#include "toimanager.h"
#ifdef TOISEQBUFFERED
#include "toiseqbuff.h"
#else
#include "toisegment.h"
#endif

#include "sambainit.h"
#include "toi2ring.h"
#include "timing.h"

#include <stdexcept>

void usage(void);
void usage(void) {
 cout<<"tsttoi2ring fitsin_phase fitsin_value fitsout_value fitsout_weight Nsamples"<<endl;
 return;
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg) {

TOIManager* mgr = TOIManager::getManager();

//-- Decodage arguments
bool fgsegmented = true;
int wsize = 512;
char *label_phase = "PHASE",  *label_bolomuv = "BOLOMUVC_26";
char *label_theta = "THETA",  *label_phi = "PHI";
bool snimplicit = false;

if(narg != 6) {usage(); exit(2);}
char * fitsin_phase    = arg[1];
char * fitsin_value    = arg[2];
char * fitsout_value   = arg[3];
char * fitsout_weight  = arg[4];
int    Nsamples        = atoi(arg[5]);

cout<<">>>> tsttoi2ring:"<<endl
    <<"Fits OutFile "<<fitsout_value<<endl
    <<"Fits WOutFile "<<fitsout_weight<<endl;
cout<<"Fits Infile Value "<<fitsin_value<<endl
    <<"  ...label_bolomuv "<<label_bolomuv<<endl;
cout<<"Fits Infile Pointing "<<fitsin_phase<<endl
    <<"  ...label_phase "<<label_phase<<endl;
 

SophyaInit();
InitTim();

//--------------------------------------------------------------------
try {
//--------------------------------------------------------------------
  
  CGT plombier(fgsegmented,wsize);
  plombier.SetDebugLevel(99);

 // FITS reader et writer
 FITSTOIReader rfitsp(fitsin_phase);
 if(snimplicit) rfitsp.setImplicitSN();
 FITSTOIReader rfitsv(fitsin_value);
 if(snimplicit) rfitsv.setImplicitSN();
 cout << "fits reader created"<<endl;

 FITSRingWriter wfits(fitsout_value);
 FITSRingWriter wwfits(fitsout_weight);
 cout << "setAperture" << endl;
 wfits.setAperture(85.);
 wwfits.setAperture(85.);
 cout << "setNSamples" << endl;
 wfits.setNSamples(Nsamples);
 wwfits.setNSamples(Nsamples);

 cout << "fits writer created"<<endl;


 // TOI Processor
 Toi2RING m2ring(Nsamples);
 cout<<"Toi2RING created"<<endl;

 // Definition des tuyaux
 cout << label_phase <<endl;
 
 plombier.Connect(rfitsp,label_theta,m2ring,"Theta");
 plombier.Connect(rfitsp,label_phi,m2ring,"Phi");
 plombier.Connect(rfitsp,label_phase,m2ring,"Phase");
 plombier.Connect(rfitsv,label_bolomuv,m2ring,"Value");
 cout<<"file out "<<fitsout_value<< endl;

 plombier.Connect(m2ring,"CircTheta",wfits,"CircTheta");
 plombier.Connect(m2ring,"CircPhi",wfits,"CircPhi");
 plombier.Connect(m2ring,"Rvalue",wfits,"signal");

//   plombier.Connect(m2ring,"CircTheta",wwfits,"CircTheta");
//   plombier.Connect(m2ring,"CircPhi",wwfits,"CircPhi");
//   plombier.Connect(m2ring,"WRvalue",wwfits,"signal");
 

 // Run
 cout<<"----- FITSReaderTOI::PrintStatus() : -----"<<endl;

 plombier.Start();
 plombier.ListTOIs(cout, 1);
 cout << "Joining ..." << endl;

 mgr->joinAll();
 PrtTim("End threads");

//--------------------------------------------------------------------
} catch (PThrowable & exc) {
 cout<<"\ntsttoi2ring: Catched Exception \n"<<(string)typeid(exc).name() 
     <<" - Msg= "<<exc.Msg()<<endl;
} catch (const std::exception & sex) {
 cout<<"\ntsttoi2ring: Catched std::exception \n" 
     <<(string)typeid(sex).name()<<endl; 
} catch (...) {
 cout<<"\ntsttoi2ring: some other exception was caught ! "<<endl;
}
//--------------------------------------------------------------------

exit(0);
}
