//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: trianglefilt.cc,v 1.7 2003-02-11 15:31:07 cmv Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

//---------------
// C++ Headers --
//---------------
#include "machdefs.h"
#include <iostream>

#include "trianglefilt.h"

//----------------
// Constructor --
//----------------
/*! 
 * \class SOPHYA::TriangleFilter
 \ingroup SkyT
 * triangle detector response
 */
TriangleFilter::TriangleFilter()
   : SpectralResponse()
{
}
/*! Constructor: nupeak is the frequency value at the hat of the triangle and
  valueatpeak is the corresponding transmission value. */
TriangleFilter::TriangleFilter(double numin, double numax,double nupeak, double valueatpeak)
   : SpectralResponse(numin, numax)
{
  _nuPeak = nupeak ;
  _peakTransmission = valueatpeak;
}

//--------------
// Destructor --
//--------------
TriangleFilter::~TriangleFilter()
{
}

//              ---------------------------
//              --  Function Definitions --
//              ---------------------------

/*! The transmission function is a triangle defined in the constructor
by numin and numax (for which the transmission goes to 0.) and
the hat of the triangle (defined by a peak frequency and the corresponding
transmission value. */
double 
TriangleFilter::transmission(double nu) const
{
  if(nu < -1.e99) nu = -1.e99;
  if(nu > 1.e99) nu = 1.e99;
  
  if(nu>_numin && nu<_nuPeak) return (_peakTransmission*nu/_nuPeak);
  if(nu>=_nuPeak && nu<_numax) return (_peakTransmission*nu/(_nuPeak-_numax)+_peakTransmission-_peakTransmission*_nuPeak/(_nuPeak-_numax));
  return 0.;
}

double 
TriangleFilter::peakFreq() const 
{
return _nuPeak;
}

double 
TriangleFilter::peakTransmission() const 
{
  return _peakTransmission;
}

/*
void
TriangleFilter::WriteSelf(POutPersist& s) 
{
  s.PutR8(this->peakFreq());
  s.PutR8(this->peakTransmission());
  s.PutR8(this->minFreq());
  s.PutR8(this->maxFreq());
  
}

void
TriangleFilter::ReadSelf(PInPersist& s)   
{
  //  double peakFreq, peakTransmission, minFreq,  maxFreq;
  s.GetR8(_nuPeak);
  s.GetR8(_peakTransmission);
  s.GetR8(_numin);
  s.GetR8(_numax);
  cout << "peakFreq - peakTransmission - minFreq - maxFreq " << endl; 
  cout <<  _nuPeak << "-" <<  _peakTransmission<< "-" <<  _numin << "-" <<  _numax << endl;

}

*/
