#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream>
#include <string>

#include "nommatvecadapter.h"
#include "piyfxdrw.h"
#include "pipodrw.h"

//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Vector 
//---------------------------------------------------------------

/* --Methode-- */
NOMAdapter_Vector::NOMAdapter_Vector(Vector* o)
  : NObjMgrAdapter(o)
{
mVec = o;
}

/* --Methode-- */
NOMAdapter_Vector::~NOMAdapter_Vector()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_Vector::Clone(AnyDataObj* o)
{
Vector* v = dynamic_cast<Vector *>(o);
if (v) return ( new NOMAdapter_Vector(v) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
string NOMAdapter_Vector::GetDataObjType()
{
  return("Vector ");
}

/* --Methode-- */
AnyDataObj* NOMAdapter_Vector::CloneDataObj(bool /*share*/)
{
return ( new Vector(*mVec) );
}


/* --Methode-- */
void NOMAdapter_Vector::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mVec->Write(pos,0,tag);
#else
string s = typeid(*mObj).name();
cout << "NOMAdapter_Vector::SavePPF() - Error : Not supported for " << s << endl;
#endif
}

/* --Methode-- */
void NOMAdapter_Vector::Print(ostream& os)
{
os << (*mVec);
}

/* --Methode-- */
PIDrawer* NOMAdapter_Vector::GetDrawer(string & dopt)
{
dopt = "thinline " + dopt;
return( new PIYfXDrawer( new POVectorAdapter(mVec, false), NULL, true) );
}

/* --Methode-- */
NTupleInterface* NOMAdapter_Vector::GetNTupleInterface(bool& adel)
{
adel = true;
return( new NTupInt_Vector(mVec) );
}


/* --Methode-- */
GeneralFitData* NOMAdapter_Vector::GetGeneralFitData(bool& adel
 ,GeneralFitData::FitErrType errtype,double errscale,double errmin
 ,int i1,int i2,int j1,int j2)
{
adel = false;
if(!mVec) return(NULL);

int n = mVec->NElts();
if(n<=0) return(NULL);

i1 = (i1<0||i1>=n)? 0: i1;
i2 = (i2<0||i2>=n||i2<i1)? n-1: i2;

GeneralFitData* mGData = new GeneralFitData(1,i2-i1+1,0);
adel = true;

for(int i=i1;i<=i2;i++) {
  double x = (double) i;
  double f = (*mVec)(i);
  double e = 1.;
  e = GeneralFitData::ComputeError(f,e,errtype,errscale,errmin);
  mGData->AddData1(x,f,e);
}

return mGData;
}

AnyDataObj* NOMAdapter_Vector::FitResidusObj(GeneralFit& mfit)
{
Vector* v = NULL;
v = mVec->FitResidus(mfit); 
return v;
}

AnyDataObj* NOMAdapter_Vector::FitFunctionObj(GeneralFit& mfit)
{
Vector* v = NULL;
v = mVec->FitFunction(mfit); 
return v;
}

// -------------------------------------------------------------

/* --Methode-- */
NTupInt_Vector::NTupInt_Vector(Vector* v)
{
mVec = v;
}

/* --Methode-- */
NTupInt_Vector::~NTupInt_Vector()
{
}

/* --Methode-- */
uint_4 NTupInt_Vector::NbLines() const
{
return(mVec->NElts());
}

/* --Methode-- */
uint_4 NTupInt_Vector::NbColumns() const 
{
return(2);
}

/* --Methode-- */
r_8* NTupInt_Vector::GetLineD(int n) const 
{
int i;
if ((n < 0) || (n >= mVec->NElts() )) 
    for(i=0; i<2; i++)  mRet[i] = 0.;
else { 
  mRet[0] = n;  mRet[1] = (*mVec)(n);
  }
return(mRet);
}

/* --Methode-- */
string NTupInt_Vector::VarList_C(const char* nx) const 
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double i,val; \n";
vardec += "i = " + nomx + "[0];  val = " + nomx + "[1]; \n";
return(vardec);
}


//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Matrix 
//---------------------------------------------------------------


/* --Methode-- */
NOMAdapter_Matrix::NOMAdapter_Matrix(Matrix* o)
  : NObjMgrAdapter(o)
{
mMtx = o;
}

/* --Methode-- */
NOMAdapter_Matrix::~NOMAdapter_Matrix()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_Matrix::Clone(AnyDataObj* o)
{
Matrix* m = dynamic_cast<Matrix *>(o);
if (m) return ( new NOMAdapter_Matrix(m) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
string NOMAdapter_Matrix::GetDataObjType()
{
  return("Matrix ");
}

/* --Methode-- */
AnyDataObj* NOMAdapter_Matrix::CloneDataObj(bool /*share*/)
{
return ( new Matrix(*mMtx) );
}

/* --Methode-- */
void NOMAdapter_Matrix::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mMtx->Write(pos,0,tag);
#else
string s = typeid(*mObj).name();
cout << "NOMAdapter_Matrix::SavePPF() - Error : Not supported for " << s << endl;
#endif
}

/* --Methode-- */
void NOMAdapter_Matrix::Print(ostream& os)
{
os << (*mMtx);
}


/* --Methode-- */
P2DArrayAdapter* NOMAdapter_Matrix::Get2DArray(string &)
{
return ( new POMatrixAdapter(mMtx, false) );
}

/* --Methode-- */
NTupleInterface* NOMAdapter_Matrix::GetNTupleInterface(bool& adel)
{
adel = true;
return( new NTupInt_Matrix(mMtx) );
}

/* --Methode-- */
GeneralFitData* NOMAdapter_Matrix::GetGeneralFitData(bool& adel
 ,GeneralFitData::FitErrType errtype,double errscale,double errmin
 ,int i1,int i2,int j1,int j2)
{
adel = false;
if(!mMtx) return(NULL);

int nx = mMtx->NRows();
int ny = mMtx->NCol();
if(nx<=0 || ny<=0) return(NULL);

i1 = (i1<0||i1>=nx)? 0: i1;
i2 = (i2<0||i2>=nx||i2<i1)? nx-1: i2;
j1 = (j1<0||j1>=ny)? 0: j1;
j2 = (j2<0||j2>=ny||j2<j1)? ny-1: j2;

GeneralFitData* mGData = new GeneralFitData(2,(i2-i1+1)*(j2-j1+1),0);
adel = true;

for(int i=i1;i<=i2;i++) for(int j=j1;j<=j2;j++) {
  double x = (double) i;
  double y = (double) j;
  double f = (*mMtx)(i,j);
  double e = 1.;
  e = GeneralFitData::ComputeError(f,e,errtype,errscale,errmin);
  mGData->AddData2(x,y,f,e);
}

return mGData;
}

AnyDataObj* NOMAdapter_Matrix::FitResidusObj(GeneralFit& mfit)
{
Matrix* m = NULL;
m = mMtx->FitResidus(mfit); 
return m;
}

AnyDataObj* NOMAdapter_Matrix::FitFunctionObj(GeneralFit& mfit)
{
Matrix* m = NULL;
m = mMtx->FitFunction(mfit); 
return m;
}

// -------------------------------------------------------------

/* --Methode-- */
NTupInt_Matrix::NTupInt_Matrix(Matrix* m)
{
mMtx = m;
}

/* --Methode-- */
NTupInt_Matrix::~NTupInt_Matrix()
{
}

/* --Methode-- */
uint_4 NTupInt_Matrix::NbLines() const
{
return( mMtx->NRows()*mMtx->NCol() );
}

/* --Methode-- */
uint_4 NTupInt_Matrix::NbColumns() const 
{
return(3);
}

/* --Methode-- */
r_8* NTupInt_Matrix::GetLineD(int n) const 
{
int i,j;
if ((n < 0) || (n >= mMtx->NRows()*mMtx->NCol() )) 
    for(i=0; i<3; i++)  mRet[i] = 0.;
else { 
  i = n/mMtx->NCol(); j = n%mMtx->NCol(); 
  mRet[0] = i;  mRet[1] = j;  mRet[2] = (*mMtx)(i,j);
  }
return(mRet);
}

/* --Methode-- */
string NTupInt_Matrix::VarList_C(const char* nx) const 
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double i,j,val; \n";
vardec += "i = " + nomx + "[0]; j = " + nomx + "[1];  val = " + nomx + "[2]; \n";
return(vardec);
}
