// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: piotoirdr.cc,v 1.2 2003-03-09 23:20:30 aubourg Exp $

#include "piotoirdr.h"

extern void fits_lock();
extern void fits_unlock();

PIOTOIReader::PIOTOIReader(string grp, string obj, string flg) {
  group = grp;
  object = obj;
  flagdef = flg;
  pioGroup = NULL;

}

PIOTOIReader::~PIOTOIReader() {
  if (pioGroup != NULL) {
    // ??
  }
}

void PIOTOIReader::init() {
  //pioTOI = new PIOObjectTOI(object.c_str(), "r");
  fits_lock();
  pioGroup = PIOOpenTOI(const_cast<char*>(object.c_str()), "r");
  fits_unlock();
  readBounds();
  bufferSize = 1000;
  cout << "PIOTOIReader : opened " << group
       << " " <<  snBegin << " - " << snEnd << endl;
  if (flagdef != "") {
    cout << "   with flagdef = " << flagdef << endl;
  }

  declareOutput(object);
}

void PIOTOIReader::readBounds() {
  PIOSTRING* flgName;
  PIOINT     nbFlg;
  PIOSTRING* toiType;
  PIOSTRING* toiName;
  PIOLONG*   beginIndex;
  PIOLONG*   endIndex;
  PIOINT     nbTOI;
  PIOSTRING  ROIGroup;

  fits_lock();
  PIOInfoTOI(&flgName,
	     &nbFlg,
	     &toiType,
	     &toiName,
	     &beginIndex,
	     &endIndex,
	     &nbTOI,
	     ROIGroup,
	     pioGroup);

  // On recupere un tableau de beginIndex, mais si on en croit
  // la doc, dans un groupe, tout le monde a les memes bornes, donc
  // on peut lire le premier ?

  snBegin = beginIndex[0];
  snEnd   = endIndex[0];

  PIOFreeInfoTOI(flgName,
		 toiType,
		 toiName,
		 beginIndex,
		 endIndex);
  fits_unlock();
}

void PIOTOIReader::run() {
  cout << "PIOTOIReader run " << group << "[" << object << "] " 
       << snBegin << " " << snEnd << endl;

  for (int snb = snBegin; snb <= snEnd; snb += bufferSize) {
    int sne = snb + bufferSize - 1;
    if (sne > snEnd) sne=snEnd;
    // TBD : check if PIODOUBLE != double;
    char command[80];
    sprintf(command, "Begin=%d; End=%d", snb, sne);
    double* data;
    uint_8*   flags = NULL;
    fits_lock();
    PIOLONG n = PIOReadTOI((void**) &data,
			   const_cast<char*>(object.c_str()),
			   "PIODOUBLE",
			   command,
			   pioGroup);
    if (flagdef != "") {
      PIOLONG nf = PIOReadFLG((PIOLONG**)&flags,   // dangereux ?
			      const_cast<char*>(flagdef.c_str()),
			      command,
			      pioGroup);
      if (nf != n) {
	cerr << "*** PIO Error, inconsistent read, data " << n << " flags " << nf << endl;
	abort();
      }
    }
    fits_unlock();
    

    if (flags != NULL) {
      putData(0, snb, sne-snb+1, data, flags);
    } else {
      putData(0, snb, sne-snb+1, data);
    }
    
    fits_lock();
    PIODeleteTOI(data, pioGroup);
    if (flags != NULL) PIODeleteFLG(flags, pioGroup);
    fits_unlock();
  }
  PIOCloseTOI(pioGroup);
}
