// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Cecile Renault
//                               Christophe Magneville
//                               Reza Ansari
// $Id: fitsringwtr.cc,v 1.4 2003-03-10 13:23:09 aubourg Exp $

#include "fitsringwtr.h"
#include "toimanager.h"

extern void fits_lock();
extern void fits_unlock();

FITSRingWriter::FITSRingWriter(string fn) {
  fname = fn;
  fstatus = 0;
  // Open file
  remove(fname.c_str());
  fits_lock();
  fits_create_file(&fptr,fname.c_str(),&fstatus);
  fits_unlock();
  name = "ringwriter";
  cout << "FITSRINGWriter:: FileName=" << name << endl;
 }

FITSRingWriter::~FITSRingWriter() {
}

void FITSRingWriter::setNSamples(long n) {
  nSamples = n;
}

void FITSRingWriter::setNRings(long n) {
  nRings = n;
}

void FITSRingWriter::setAperture(double a) {
  aperture = a;
}

void FITSRingWriter::init() {
  declareInput("CircTheta");
  declareInput("CircPhi");
  declareInput("signal");
}

void FITSRingWriter::run() {
  //int snb = getMinIn();   ON IGNORE ICI
  //int sne = getMaxIn();   ON IGNORE ICI
  
  char buf[100];
  
  fits_lock();
  fits_create_img(fptr,BYTE_IMG,0,NULL,&fstatus);
  fits_write_date(fptr, &fstatus);
  fits_write_comment(fptr,"ArchTOIPipe FITSRingWriter",&fstatus);
  strcpy(buf, "RINGSET");
  fits_write_key(fptr, TSTRING, "PDMTYPE",  &buf, "Planck Data Model Type", &fstatus);
  fits_write_key(fptr, TLONG,   "NCIRCLES", &nRings, "Number of rings", &fstatus);
  fits_unlock();
  
  for (int ring = 0; ring<nRings; ring++) {
    char* ttype = "DATA";
    char* tform = "1D";
    char xname[100];
    sprintf(xname, "CRING_%d", ring);

    fits_lock();
    fits_create_tbl(fptr,BINARY_TBL,nSamples,1,&ttype,&tform,NULL,xname,&fstatus);
    strcpy(buf, "RINGDATA");
    fits_write_key(fptr, TSTRING, "PDMTYPE",  &buf, "Planck Data Model Type", &fstatus);
    double theta = getData(0, ring*nSamples);
    fits_write_key(fptr, TDOUBLE, "CIRTHETA", &theta, "Theta angle in radians", &fstatus);
    double phi = getData(1, ring*nSamples);
    fits_write_key(fptr, TDOUBLE, "CIRPHI", &phi, "Phi angle in radians", &fstatus);
    fits_write_key(fptr, TDOUBLE, "CIRAPER", &aperture, "Aperture angle in radians", &fstatus);
    fits_write_key(fptr, TLONG, "NSAMPLES", &nSamples, "Number of samples on the circle", &fstatus);
    fits_unlock();
    wontNeedBefore(ring*nSamples);

    for (int i=0; i<nSamples; i++) {
      double data = getData(2, ring*nSamples+i);
      fits_lock();
      fits_write_col(fptr, TDOUBLE, 1,i+1,1,1, &data, &fstatus);
      fits_unlock();
    }

    fits_lock();
    fits_close_file(fptr, &fstatus);
    fits_report_error(stderr, fstatus);
    fits_unlock();
  }

}
