#  -*- makefile -*-
# #########################  Sophya ############################# 
# ##### LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA #####
# ############################################################### 
# General setup GNU Makefile for Sopyha/Planck. To be included in all makefiles.  
# Define  makefile variables according to CPU 
# MACHEROSD = `uname | sed 's/-//'`   i.e. { AIX HPUX OSF1 Linux ... }
# and compilers {g++, cxx, KCC, xlC, aCC, ...}
# 
# Makefile variables set are:
# - Path to Exec, Include, Libs, Obj directories (from DPCDEVREP env. var.)
#     i.e. variables LIB, OBJ, EXE, INC 
#---------------------------------------------------------------------------

# define MACHEROS from uname
MACHEROS := $(shell echo `uname`)
# define the -D option
MACHEROSD := $(shell echo `uname | sed 's/-//'`)
# Le sous-repertoire des objets specifique machine-compilo
#   OSF1 : Alpha avec gcc
#   OSF1-cxx : Alpha avec cxx

#### C++
ifdef EROSCXX
  CXX := $(EROSCXX)
endif

ifeq ($(CXX),gcc)
  override CXX := g++
endif

ifeq ($(EROSCXX),egcs++)
  # en fait de compilo de egcs++ s'appelle g++ !
  # comme il faut bien differentier ln -s /usr/bin/g++ /usr/bin/egcs++
  override CXX := egcs++
endif

ifeq ($(CC),xlC)
  override CXX := xlC
endif

#### C
ifeq ($(CXX), xlC)
  override CC := xlC
endif

ifeq ($(CXX), g++)
  CC := gcc
endif

ifeq ($(EROSCXX), egcs++)
  CC := egcs
endif

#### Fortran (tout ce qui est lie au Fortran est defini ici #############
FC = f77
ifeq (${MACHEROS},Linux)
#  override FC := f77
  override FC := g77
endif

ifeq (${MACHEROS},OSF1)
  LIBFORT = -lfor -lFutil -lots -lUfor
endif
ifeq (${MACHEROS},Linux)
  #LIBFORT = -lf2c
  LIBFORT = -lg2c
endif
#########################################################################


MACHDIR := $(MACHEROS)-$(CXX)


#-
#-   Define Makefile paths
#-  (NE PAS TOUCHER CES LIGNES: generation automatique de MakefileUser.h)
#-  
PP  := ${DPCDEVREP}/${MACHDIR}/
LIB := ${PP}/Libs/
SLB := ${PP}/ShLibs/
OBJ := ${PP}/Objs/
EXE := ${PP}/Exec/
INC := ${DPCDEVREP}/Include/
GLB := /usr/local/lib/
#--

#  Si Makefile.h utilise pour la construction d'autres librairies
ifdef MYBUILDDEVREP
  MYPP := ${MYBUILDDEVREP}/${MACHDIR}/
  MYLIB := ${MYPP}/Libs/
  MYSLB := ${MYPP}/ShLibs/
  OBJ := ${MYPP}/Objs/
  EXE := ${MYPP}/Exec/  
endif

#-   Flag for optimisation/ debug
# Pour forcer sans debug, DBGFLAG = -g0
ifndef OPTFLAG
  OPTFLAG  := -O
endif

ifndef DBGFLAG
  DBGFLAG  := -g
#  Probleme sur DEC/OSF1 -g avec g++/egcs pose probleme a l'assembleur
#                    Reza 09/99 - On met -gcoff
  ifeq (${MACHEROS},OSF1)
    ifeq ($(CXX), g++)
      override DBGFLAG := -gcoff
    endif
  endif
endif

# DBGFLAG a -g0 veut dire pas de debug. Tout le monde a ca par defaut...
ifeq ($(DBGFLAG), -g0)
  override DBGFLAG :=
endif

# xlC ne connait pas -O0, par defaut il n'optimise pas.
ifeq ($(OPTFLAG), -O0)
  ifeq ($(CC), xlC)
    override OPTFLAG :=
  endif
endif

AR       := ar
ARFLAGS  := -rcs
ARARGS   := ?

# le gnu ar ne fonctionne pas bien sur OSF...
ifeq (${MACHEROS},OSF1)
AR       := /usr/bin/ar
endif
# et sur AIX il nous sort des tas de warnings inutiles
ifeq ($(MACHEROS),AIX)
AR := /usr/bin/ar
endif

ifeq ($(MACHEROS),Darwin)
AR := libtool
ARFLAGS := -static -o
ARARGS := ^
EROSCXX := g++
CXX := g++
CC := cc
endif

#   Avec certains compilateurs C++ (KCC, aCC) , il faut fabriquer les librairies et 
# les shared libs avec la meme commande 
override ARCXX := $(AR) 
override ARCXXFLAGS := $(ARFLAGS) 
#RZ0999 ifeq ($(CXX),KCC)
#RZ0999 override  ARCXX  := KCC
#RZ0999 override ARCXXFLAGS  := -o
#RZ0999 endif
ifeq ($(CXX),aCC)
override ARCXX  := aCC 
override ARCXXFLAGS  := -o
endif

# Les chemins speciaux pour includes systemes et bibliotheques
ifeq (${MACHEROS},HP-UX)
  XLDLIBS := -L.
  XCFLAGS := 
  XCPPFLAGS :=  
endif


#  Pour compiler PI, sous Linux, les includes et libs se trouve souvent ds /usr/X11/include /usr/X11/lib/
ifeq (${MACHEROS},Linux)
  XLDLIBS := -L/usr/X11/lib -L/usr/X11R6/lib
  XCPPFLAGS := -I/usr/X11/include -I/usr/X11R6/include
  LDLIBS := -ldl
endif

ifeq (${MACHEROS},Darwin)
  XLDLIBS := -L/usr/X11R6/lib -L/sw/lib -ldl
  XCPPFLAGS := -I/usr/X11R6/include -I/sw/include 
  XCFLAGS := -fno-coalesce -fkeep-inline-functions -fno-common
endif

# Chemin pour les include et fichiers d'autres librairies
EXTINCPI := 
EXTLIBPL := 
EXTSLBPL := 
EXTINCPATH := 
EXTLIBPATH := 
EXTSLBPATH := 

ifdef EXTLIBDIR
 EXTINCPI := -I$(EXTLIBDIR)/Include/
 EXTLIBPL := -L$(EXTLIBDIR)/$(MACHDIR)/Libs/
 EXTSLBPL := -L$(EXTLIBDIR)/$(MACHDIR)/ShLibs/
 EXTINCPATH := $(EXTLIBDIR)/Include/
 EXTLIBPATH := $(EXTLIBDIR)/$(MACHDIR)/Libs/
 EXTSLBPATH := $(EXTLIBDIR)/$(MACHDIR)/ShLibs/
endif

#  S'il y a des flags particulier pour un module de compilation
#ifndef MODULECPPFLAGS
  override MODULECPPFLAGS :=
#endif

CPPFLAGS     :=  -I${INC} $(EXTINCPI) $(XCPPFLAGS) -D${MACHEROSD} $(MODULECPPFLAGS)

#  Si la variable d'environnement SOPHYA_DEBUG est definie : Activation des 
#  compilations conditionnelles pour le debug/bound-checking/... ds le code
ifdef SOPHYA_DEBUG 
  CPPFLAGS   := $(CPPFLAGS) -DSOPHYA_DEBUG
endif

# Les options selon les divers compilateurs
# GNU
ifeq ($(CC), gcc)
  CFLAGS       := -Wall -Wpointer-arith \
                  -Wmissing-prototypes -Wsynth -I$(INC) $(XCFLAGS) \
                  $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
  LDLIBS       := $(LDLIBS) $(XLDLIBS)
endif
ifeq ($(CC), egcs)
  CFLAGS       := -Wall -Wpointer-arith \
                  -Wmissing-prototypes -Wsynth -I$(INC) $(XCFLAGS) \
                  $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
  LDLIBS       := $(LDLIBS) $(XLDLIBS)
endif

ifeq ($(CXX), g++)
  CXXFLAGS       := -Wall -Wpointer-arith \
                    -Wmissing-prototypes -Wsynth -I$(INC) $(XCFLAGS) \
                    $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) 
  LDLIBS      := $(LDLIBS) $(XLDLIBS)
#  ifdef NOSHLIB 
#    LDFLAGS := -static
#  endif
endif
ifeq ($(CXX), egcs++)
  CXXFLAGS       := -Wall -Wpointer-arith \
                    -Wmissing-prototypes -Wsynth -I$(INC) $(XCFLAGS) \
                    $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) 
  LDLIBS      := $(LDLIBS) $(XLDLIBS)
  ifdef NOSHLIB 
    LDFLAGS := -static
  endif
endif

# Compilateur natif (GNU-gcc) sous MacOSX (Darwin)
ifeq (${MACHEROS},Darwin)
  CFLAGS       := -Wall -Wpointer-arith \
                  -Wmissing-prototypes -Wsynth -I$(INC) $(XCFLAGS) \
                  $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
  LDLIBS       := $(LDLIBS) $(XLDLIBS)
endif

# Compilateur C natif HP-UX
ifeq (${MACHEROS},HP-UX)
ifeq ($(CC),cc)                                    
  CFLAGS       :=  +Z -Aa -Ae $(XCFLAGS) $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) 
  FFLAGS       :=  -Aa -I${INC}   -D${MACHEROSD}  
  CPPFLAGS     :=  -I${INC}  -I$(INC)/tnt -D${MACHEROSD} \
               -D_HPUX_SOURCE $(MODULECPPFLAGS)
  LDLIBS      := $(XLDLIBS)
  override NOSHLIB := Y

endif
ifeq ($(CXX),aCC)
  CXXFLAGS := $(XCFLAGS) $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) +Z -D__aCC__
#  -DCOMPILER_EXCEPTIONS -D__ANSI_TEMPLATES__  definis ds defs.h
endif
endif

# AIX, xlC comme compilateur C et C++
ifeq ($(CXX), xlC)
  CFLAGS := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) $(XCFLAGS)
  CPPFLAGS := -I$(INC)/Syst -I${INC}  -I$(INC)/tnt -D${MACHEROSD} $(MODULECPPFLAGS)
  CXXFLAGS     := $(CFLAGS) -D__xlC 
# -DCOMPILER_EXCEPTIONS defini ds defs.h
  LDLIBS      := $(XLDLIBS)

# Pour faire des bibliotheques partagees, il faut faire un truc du
# style 
#ld -o shrsub.o subs1.o subs2.o -bE:shrsub.exp -bM:SRE -lc

# Pour le moment on ne se fatigue pas, tant pis
  override NOSHLIB := Y

# Et puis 1540-293: (W) est un FAUX warning, on supprime les warnings
  CXXFLAGS := -qflag=e $(CXXFLAGS)
endif


ifeq ($(CXX), cxx)
  ifeq ($(DBGFLAG), -g)
    ifdef OPTFLAG
      override DBGFLAG := -g1
    endif
#    ifdef XOPT
#      override DBGFLAG := -g1
#    endif
  endif

# chemin pour repository CXX
 REP := $(OBJ)/cxxrep/
 REPPI := $(OBJ)/cxxrep_PI/
 REPCXX := -ptr $(OBJ)/cxxrep/
 ifdef MODULECXXREPNAME
   REPCXX := -ptr $(OBJ)/cxxrep_$(MODULECXXREPNAME)/  -ptr $(OBJ)/cxxrep/
   REPM := $(OBJ)/cxxrep_$(MODULECXXREPNAME)/
 endif

  LDLIBS      := $(XLDLIBS) -lrt

  CXXFLAGS := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)   \
              $(REPCXX) -no_implicit_include 
# $(REPCXX) -no_implicit_include -D__USE_STD_IOSTREAM  passe pas avec cxx 6.0 Reza 23/12/99
  CFLAGS := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
#  CXXFLAGS := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)  \
#	      -nopt -define_templates
  ifeq ($(XOPT), 1)
    override DBGFLAG :=
    CXXFLAGS := $(DBGFLAG) $(MYCFLAGS)  \
	        $(REPCXX) -fp_reorder \
	        -O5 -inline speed -tune host
  endif
  ifeq ($(XOPT), 2)
    override DBGFLAG :=
    CXXFLAGS := $(DBGFLAG) $(MYCFLAGS)  \
	      $(REPCXX) -fp_reorder \
	      -O5 -inline speed -tune host \
	      -assume trusted_short_alignment
  endif
  ifeq ($(XOPT), 3)
    override DBGFLAG :=
    CXXFLAGS := $(DBGFLAG) $(MYCFLAGS)  \
	      $(REPCXX) -fp_reorder \
	      -O5 -inline speed -tune host \
	      -assume trusted_short_alignment \
	      -non_shared -om
    override NOSHLIB := Y
  endif

# le fichier X11/Xlib.h contient des declarations de fonctions sans type
# Cela genere un grand nombre de warning avec cxx V6
# La variable MODULEDECCXXFLAGS permet de specifier des options de compilation 
# pour un module donne  
  ifdef MODULEDECCXXFLAGS
    CXXFLAGS := $(CXXFLAGS) $(MODULEDECCXXFLAGS)
  endif
endif
ifeq ($(CC),cc)
  ifeq ($(MACHEROS),OSF1)
  ifeq ($(XOPT), 1)
    CFLAGS :=  $(DBGFLAG) $(MYCFLAGS) -fp_reorder \
	      -O4 -inline speed -tune host
  endif
  ifeq ($(XOPT), 2)
    CFLAGS :=  $(DBGFLAG) $(MYCFLAGS) -fp_reorder \
	      -O4 -inline speed -tune host \
	      -assume trusted_short_alignment -fast
  endif
  ifeq ($(XOPT), 3)
    CFLAGS :=  $(DBGFLAG) $(MYCFLAGS) -fp_reorder \
	      -O4 -inline speed -tune host \
	      -assume trusted_short_alignment -fast \
	      -non_shared -om
  endif
  endif
endif

# --- Compilateur KAI  (OK pour v 3.3)
ifeq ($(CXX), KCC)
  CXXFLAGS     :=  --exceptions --rtti  --auto_instantiation --one_instantiation_per_object -D__KCC__
  CXXFLAGS  := $(CXXFLAGS) $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
  CFLAGS := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
# Flag --one_instantiation_per_object mis - Reza 02/03/99
endif

# --- Systeme IRIX64 de Silixon Graphics (SGI) 
ifeq ($(MACHEROS), IRIX64)
# --- Compilateur natif CC de SGI 
  ifeq ($(CXX), CC)
    CFLAGS  := $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) 
    CXXFLAGS := -prelink -D__SGICC__ -LANG:std $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
    LINK.cc := CC $(CPPFLAGS) -D__SGICC__ -LANG:std $(DBGFLAG) $(OPTFLAG)
#  sur SGI, les libs/executables ont deux formats 32 et 64 bits (trois avec o32)
#  -n32 Generates a (new) 32-bit object default to -mips3 if -mips4 has not been specified
#  -64 Generates a 64-bit object - defaults to -mips4 if -mips3 has not been specified
#  La variable d'environnement SOPHYA_SGI64 controle cette option
    ifdef SOPHYA_SGI64
      CFLAGS  := -64 -DSGI_ARCH64 $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS) 
      CXXFLAGS := -64 -prelink -DSGI_ARCH64 -D__SGICC__ $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
      LINK.cc := CC -64 $(CPPFLAGS) -D__SGICC__ $(DBGFLAG) $(OPTFLAG)
    endif
  endif
  ifeq ($(CXX), g++)
    ifdef SOPHYA_SGI64
      CFLAGS  := $(CFLAGS) -DSGI_ARCH64 -mips4 -mlong64 -mfp64 -mgp64 -mabi=64
      CXXFLAGS := $(CXXFLAGS) -DSGI_ARCH64 -mips4 -mlong64 -mfp64 -mgp64 -mabi=64
      LINK.cc := $(LINK.cc) -DSGI_ARCH64 -mips4 -mlong64 -mfp64 -mgp64 -mabi=64
    endif
  endif
endif

# Autres compilateurs natifs.

#  CFLAGS       :=  -I$(INC) $(XCFLAGS) $(OPTFLAG) $(DBGFLAG) $(MYCFLAGS)
#  CXXFLAGS     := $(CFLAGS)
#  LDLIBS      := $(XLDLIBS)

#- redefine implicit rule. Les .o sont dans $(OBJ).
$(OBJ)%.o:%.c
	$(COMPILE.c) -o $@ $<

$(OBJ)%.o:%.cc
	$(COMPILE.cc) -o $@ $<

$(OBJ)%.o:%.f
	$(COMPILE.f) -o $@ $< 

#OSF1
#LDFC est f77
#LDFCFLAGS est rien

#parfois
#LDFC est cc
#LDFCFLAGS est -ltruc

#------------------------------------------------- End of Makefile.h ------- 
