// Class for representing the main antenna lobe
//        R. Ansari            1998-2000
// DAPNIA/SPP (Saclay) / CEA    LAL - IN2P3/CNRS  (Orsay)

#ifndef MLOBE_H_SEEN
#define MLOBE_H_SEEN

#include <math.h>
#include <iostream>

#include "sphericalmap.h"


namespace SOPHYA {  

// Classe MainLobe
// Classe pour calcul du lobe principal
// Les valeurs du lobe sont calcules dans des pixels
// disposes sur "nc" couches avec pavage hexagonal autour de Teta=0, Phi=0
// Le lobe est gaussien, de sigma = "sig" - Les couches sont construites 
// toutes les "dels" * sigma 
// NPix() renvoie le nombre total de pixels du lobe 
// SetDirection() permet d orienter le lobe dans la direction "teta, phi"
// Value() renvoie la valeur du lobe, ainsi que les teta,phi du pixel "kpx"
// Convol() renvoie la valeur lobe convolue avec le ciel (sphere) "sph"

class MainLobe {
public:
			MainLobe(float sig, float dels=0.5, int nc=3);
			~MainLobe();
        inline int      NPix() {return mNpix; }            
        inline float    Sigma() {return mSigma; }            
        inline double   Integral() {return mTotVal; }            
               void     SetDirection(float teta, float phi);
	       double   Value(int kpx, float& teta, float& phi);
               double   Convol(SphericalMap<double>& sph);
	       void     Print(ostream& os) const; 

float mSigma, mDels;
int mNpix, mNC;
double mTotVal;
float mDirTet, mDirPhi;
float* mT0; 
float* mP0; 
float* mTC; 
float* mPC; 
float* mDx;
float* mDy;
float* mDr;
double* mVal;
};

inline ostream& operator << (ostream& s, MainLobe const & ml)
  {  ml.Print(s);  return(s);  }

} // namespace SOPHYA

#endif
