// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Cecile Renault
//                               Christophe Magneville
//                               Reza Ansari
// $Id: fitsringrdr.h,v 1.1 2003-03-24 10:59:45 cecile Exp $

#ifndef FITSRINGRDR_H
#define FITSRINGRDR_H

#include "toi.h"
#include "toiprocessor.h"
#include "fitsio.h"

class FITSRingReader : public TOIProcessor {
public:
  FITSRingReader(string fn,int buff_sz=1024);
  ~FITSRingReader();


  void         setBufferSize(int buffsz=1024);
  inline int   getBufferSize() { return Buff_Sz; }
  
  void  init();
  void  run();
  
protected:
  virtual void openFile(string fn);
  int nSamples;
  long nRings;
  double aperture;
  string fname;
  fitsfile *fptr;
  int fstatus;
  int Buff_Sz; // buffer size = nSamples
  vector<string> allfn;
};


#endif
