//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: fitsringrdr.cc,v 1.1 2003-03-24 10:59:45 cecile Exp $

#include "fitsringrdr.h"
#include "toimanager.h"
#include <sched.h>

extern void fits_lock();
extern void fits_unlock();

FITSRingReader::FITSRingReader(string fn,int buff_sz) {
  fname = fn;
  allfn.push_back(fn);
  cout<<"FITSRingReader::FITSRingReader"<<endl;
  name = "rdr";
  fptr = NULL;
}

FITSRingReader::~FITSRingReader() {
}


void FITSRingReader::openFile(string fn) {
  fits_lock();
  if (fptr) {
    fits_close_file(fptr,&fstatus);
    fptr = NULL;
  }
  fname = fn;
  cout << "FITSRingReader::open FileName=" << fname << endl;
  fstatus = 0;
  // Open file
  fits_open_file(&fptr,fname.c_str(),READONLY,&fstatus);
  if (fstatus != 0) {
    fits_report_error(stderr, fstatus);
    fits_unlock();
    throw IOExc("FITSRingReader::openFile() fitsio error");
  }
  
  // Go to first extension, which should be a BINTABLE
  
  int simple, bitpix, naxis;
  long naxes;
  long pcount, gcount;
  int extend;
  fits_read_imghdr(fptr, 1, &simple, &bitpix, 
		   &naxis, &naxes, &pcount, &gcount, &extend, &fstatus);

  fits_movabs_hdu(fptr, 2, NULL, &fstatus);
  
  fits_get_num_cols(fptr,&nSamples,&fstatus);

  cout << "FITSRingReader nSamples = " << nSamples << endl;  
 
  fits_unlock();  
}

void FITSRingReader::init() {

  declareOutput("CircTheta");
  declareOutput("CircPhi");
  declareOutput("signal");

}
void FITSRingReader::run() {

  fits_lock();

  fits_read_key(fptr, TLONG,   "NCIRCLES", &nRings, "Number of rings", &fstatus);
  fits_unlock();
  
  char xname[100],buf[100];
  double theta,phi;
  int anyNul;
  
  for (int ring = 0; ring<nRings; ring++) {
    sprintf(xname, "CRing_%d", ring);


    fits_lock();
    fits_movabs_hdu(fptr, ring+2, NULL, &fstatus);
    strcpy(buf, "RINGDATA");
    fits_read_key(fptr, TSTRING, "PDMTYPE",  &buf, "Planck Data Model Type", &fstatus);
    fits_read_key(fptr, TDOUBLE, "CIRTHETA", &theta, "Theta angle in radians", &fstatus);
    fits_read_key(fptr, TDOUBLE, "CIRPHI", &phi, "Phi angle in radians", &fstatus);
    fits_read_key(fptr, TDOUBLE, "CIRAPER", &aperture, "Aperture angle in radians", &fstatus);
    fits_read_key(fptr, TLONG, "NSAMPLES", &nSamples, "Number of samples on the circle", &fstatus);
    fits_unlock();

    for (int i=0; i<nSamples; i++) {
      double data;
      fits_lock();
      fits_read_col_dbl(fptr,1,i+1,1,1,0,&data,&anyNul,&fstatus);
      putData(0, ring*nSamples+i,theta);
      putData(1, ring*nSamples+i,phi);
      putData(2, ring*nSamples+i,data);
      fits_unlock();      
    }
  }
  
  fits_lock();
  if (fptr) {
    fits_close_file(fptr,&fstatus);
    fptr = NULL;
  }
  fits_unlock();
}
