// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: ring2cout.h,v 1.1 2003-03-24 11:07:00 cecile Exp $

#ifndef TOI2RING_H
#define TOI2RING_H

#include "toiprocessor.h"
#include "flagtoidef.h"

//-- Un generateur de RING a partir d'une sphere et de 2 TOIs coordin1,coordin2
// Lecture de 2 TOI coord1,coord2 et d'une Sphere Healpix
// Sortie de 3 RING coord1,coord2,boloMuV
//
// Structure generale :
//             Sphere ---- |
//                         |
//                     -----------
//   toi phase    ---> |         | ---> ring value
//                     |Ring2cout | ---> ring weight
//   toi value    ---> |         | 
//                     -----------

class Ring2cout : public TOIProcessor {
public:
                 Ring2cout();
  virtual	~Ring2cout();


  virtual void	init(void);
  virtual void	run(void);



  // Print
  void Print(::ostream & os);
  inline long 	ProcessedSampleCount() const { return totnscount; }
  inline long	ProcessedRingCount() const { return nRings; }

protected:
  long Nsamples;
  long totnscount;
  long nRings;
  
};

#endif
