// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: ring2cout.cc,v 1.2 2003-03-26 09:48:53 cecile Exp $

#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"
#include "ring2cout.h"
// La valeur "Pi" doit etre celle de smathconst.h a cause du test sur theta
#include "smathconst.h"

////////////////////////////////////////////////////////////////////////
Ring2cout::Ring2cout(long n)
  :totnscount(0), nRings(0)
{
  setNSamples(n);
}

Ring2cout::~Ring2cout()
{
}


////////////////////////////////////////////////////////////////////////
void Ring2cout::Print(::ostream & os)
{
}

////////////////////////////////////////////////////////////////////////
void Ring2cout::init() {
  cout << "Ring2cout::init" << endl;
  declareInput("Theta");     // input  index 0
  declareInput("Phi");     // input  index 1
  declareInput("Phase");     // input  index 2
}

////////////////////////////////////////////////////////////////////////
void Ring2cout::run() {

  cout << "///////////////////////////////// coucou !" << endl;
  
  

//---------------------------------------------------------
try {
  uint_4 mSnRead=0, mSnFilled=0, BadCoorRange=0;
  double ctheta[Nsamples],cphi[Nsamples],val[Nsamples];

  for (int k=0; k<nRings; k++) {
    
    getData(0,k*Nsamples,Nsamples,ctheta);
    getData(1,k*Nsamples,Nsamples,cphi);
    getData(2,k*Nsamples,Nsamples,val);
    mSnRead ++;
    
    cout << " ring " << k << endl;
    for (int i=i; i< Nsamples;i++)
      cout << ctheta << " " << cphi<< " " << val<< endl;
    totnscount++;
    
  }
  
  cout<<"RING2Toi::run: Samples Read "<<mSnRead
      <<" Filled "<<mSnFilled
      <<" BadCoorRange="<<BadCoorRange<<endl;
  
  //---------------------------------------------------------
} catch (PException & exc) {
  cout<<"Ring2cout: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}
 

 return;
}


















