//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: fitsringrdr.cc,v 1.4 2003-04-04 14:17:03 cecile Exp $

#include "fitsringrdr.h"
#include "toimanager.h"
#include <sched.h>

extern void fits_lock();
extern void fits_unlock();

FITSRingReader::FITSRingReader(string fn,int buff_sz) {
  fname = fn;
  allfn.push_back(fn);
  cout<<"FITSRingReader::FITSRingReader"<<endl;
  cout<<"FITSTOIReader::inited "<<inited<<" bsz="<<Buff_Sz<<endl;
  name = "rdr";
  fptr = NULL;
  totnscount = 0;
}

FITSRingReader::~FITSRingReader() {
}


void FITSRingReader::setBufferSize(int buffsz)
{
  Buff_Sz = (buffsz>0) ? buffsz: 1024;
  return;
}

void FITSRingReader::setNRings(long n) {
  nRings = n;
}

void FITSRingReader::openFile(string fn) {
  cout << "(((((((((((((((((((((((((((((((((((((((((((" << endl;
  
  fits_lock();
  if (fptr) {
    fits_close_file(fptr,&fstatus);
    fptr = NULL;
  }
  fname = fn;
  cout << "FITSRingReader::open FileName=" << fname << endl;
  fstatus = 0;
  // Open file
  fits_open_file(&fptr,fname.c_str(),READONLY,&fstatus);
  if (fstatus != 0) {
    fits_report_error(stderr, fstatus);
    fits_unlock();
    throw IOExc("FITSRingReader::openFile() fitsio error");
  }
  
  // Go to first extension, which should be a BINTABLE
  
  int simple, bitpix, naxis;
  long naxes;
  long pcount, gcount;
  int extend;
  fits_read_imghdr(fptr, 1, &simple, &bitpix, 
		   &naxis, &naxes, &pcount, &gcount, &extend, &fstatus);

  fits_movabs_hdu(fptr, 2, NULL, &fstatus);
  
  fits_get_num_rows(fptr,&nSamples,&fstatus);

  cout << "FITSRingReader nSamples = " << nSamples << endl;  
 
  fits_unlock();  
}

void FITSRingReader::init() {

  declareOutput("CircTheta");
  declareOutput("CircPhi");
  declareOutput("signal");
  openFile(fname);
}

int FITSRingReader::calcMinOut() {
  chkinit();
  TOIManager* mgr = TOIManager::getManager();
  int firstReq = mgr->getRequestedBegin();
  return snBegin > firstReq ? snBegin : firstReq;
}

int FITSRingReader::calcMaxOut() {
  chkinit();
  TOIManager* mgr = TOIManager::getManager();
  int lastReq = mgr->getRequestedEnd();
  return snEnd < lastReq ? snEnd : lastReq;
}


// ajout vf 31/07/2002
bool FITSRingReader::checkSampleLimits(long& min, long& max, int pass)
{
  bool sample_ok=true;
  chkinit();
  return TOIProcessor::checkSampleLimits(min, max, pass);
}

void FITSRingReader::calcSampleLimits(long& min, long& max)
{
  chkinit(); 
  cout << "calc  " << name << " in  " << min << " - " << max << " ; " << snBegin << " - " << snEnd << endl;
  
  min=min<snMin?snMin:min;
  max=max>snMax?snMax:max;
  snBegin=snMin;
  snEnd=snMax;
  cout << "calc  " << name << " out " << min << " - " << max << " ; " << snBegin << " - " << snEnd << endl;
  //cout << "fitstoirdr : limites temporaires calculees : " << snBegin << " , " << snEnd << endl;

}
// fin ajout vf



void FITSRingReader::run() {

  fits_lock();
  fits_movabs_hdu(fptr, 1, NULL, &fstatus);
  char commt[200];
  fits_read_key(fptr, TLONG,   "NCIRCLES", &nRings, commt, &fstatus);
  fits_unlock();
  
  char xname[100],buf[100];
  double theta,phi;
  int anyNul;
  
  for (int ring = 0; ring<nRings; ring++) {
    sprintf(xname, "CRing_%d", ring);

    fits_lock();
    fits_movabs_hdu(fptr, ring+2, NULL, &fstatus);
    strcpy(buf, "RINGDATA");
    fits_read_key(fptr, TSTRING, "PDMTYPE",  &buf, commt, &fstatus);
    fits_read_key(fptr, TDOUBLE, "CIRTHETA", &theta, commt, &fstatus);
    fits_read_key(fptr, TDOUBLE, "CIRPHI", &phi, commt, &fstatus);
    fits_read_key(fptr, TDOUBLE, "CIRAPER", &aperture, commt, &fstatus);
    fits_read_key(fptr, TLONG, "NSAMPLES", &nSamples, commt, &fstatus);
    fits_unlock();
    wontNeedBefore(ring*nSamples);
    cout << "!!!!!!! RING " << ring << endl;
    
    for (int i=0; i<nSamples; i++) {
      double data;
      fits_lock();
      fits_read_col_dbl(fptr,1,i+1,1,1,0,&data,&anyNul,&fstatus);
      putData(0, ring*nSamples+i,theta);
      putData(1, ring*nSamples+i,phi);
      putData(2, ring*nSamples+i,data);
      fits_unlock();      
    }
  }
  
  fits_lock();
  fits_report_error(stderr, fstatus);
  fits_close_file(fptr,&fstatus);
  fits_unlock();
}


// affichage des limites
void FITSRingReader::printLimits()
{
  cout << "fitsringrdr " << name <<" : limites calculees : " << snBegin << " , " << snEnd << endl;
}

