// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: ring2cout.cc,v 1.4 2003-04-04 14:17:37 cecile Exp $

#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"
#include "ring2cout.h"
// La valeur "Pi" doit etre celle de smathconst.h a cause du test sur theta
#include "smathconst.h"

////////////////////////////////////////////////////////////////////////
Ring2cout::Ring2cout(long ns, long nr)
  :totnscount(0)
{
  setNSamples(ns);
  setNRings(nr);
}

Ring2cout::~Ring2cout()
{
}


////////////////////////////////////////////////////////////////////////
void Ring2cout::Print(::ostream & os)
{
}

////////////////////////////////////////////////////////////////////////
void Ring2cout::init() {
  cout << "Ring2cout::init" << endl;
  declareInput("Theta");     // input  index 0
  declareInput("Phi");     // input  index 1
  declareInput("Phase");     // input  index 2
}

////////////////////////////////////////////////////////////////////////
void Ring2cout::run() {

//---------------------------------------------------------
try {
  uint_4 mSnRead=0, mSnFilled=0, BadCoorRange=0;

  cout << " ring " << Nrings << " ns " << Nsamples<< endl;
  double ctheta[Nsamples],cphi[Nsamples],val[Nsamples];
  for (int k=0; k<Nrings; k++) {
    
    getData(0,k*Nsamples,Nsamples,ctheta);
    getData(1,k*Nsamples,Nsamples,cphi);
    getData(2,k*Nsamples,Nsamples,val);
    mSnRead ++;
    
    for (int i=0; i< Nsamples;i++)
      cout << Nrings << " " << k <<" " << i <<" " << ctheta[i] << " " << cphi[i]<< " " << val[i]<< endl;
    totnscount+=Nsamples;
    
  }
 
  cout<<"RING2cout::run: Samples Read "<<mSnRead
      <<" Filled "<<mSnFilled
      <<" BadCoorRange="<<BadCoorRange<<endl;
  
  //---------------------------------------------------------
} catch (PException & exc) {
  cout<<"Ring2cout: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}
 

 return;
}


















