//#define TOISEQBUFFERED

#include <unistd.h>
#include "toi.h"
#include "cgt.h"
#include "toiprocessor.h"
#include "fitsringrdr.h"
#include "toimanager.h"
#ifdef TOISEQBUFFERED
#include "toiseqbuff.h"
#else
#include "toisegment.h"
#endif

#include "sambainit.h"
#include "ring2cout.h"
#include "timing.h"

#include <stdexcept>

void usage(void);
void usage(void) {
  cout<<"tsttoi2ring fitsin_ring Nrings"<<endl;
 return;
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg) {

TOIManager* mgr = TOIManager::getManager();

//-- Decodage arguments
bool fgsegmented = true;
int wsize = 512;
bool snimplicit = false;

if(narg != 3) {usage(); exit(2);}
 char * fitsin_ring    = arg[1];
 long nr=atoi(arg[2]);
 
 cout<<">>>> tsttoi2ring:"<<endl;
cout<<"Fits Infile Value "<<fitsin_ring<<endl;
 

SophyaInit();
InitTim();

//--------------------------------------------------------------------
try {
//--------------------------------------------------------------------
  
  CGT plombier(fgsegmented,wsize);
  plombier.SetDebugLevel(99);

 // FITS reader et writer
 FITSRingReader rfitsr(fitsin_ring);
 rfitsr.setNRings(nr);


 // TOI Processor
 Ring2cout ring2p(1024,nr);
 cout<<"RING2cout created"<<endl;


 // Definition des tuyaux
 
 plombier.Connect(rfitsr,"signal",ring2p,"Phase");


 // Run
 cout<<"----- FITSReaderTOI::PrintStatus() : -----"<<endl;

 plombier.Start();
 plombier.ListTOIs(cout, 1);
 cout << "Joining ..." << endl;

 mgr->joinAll();
 PrtTim("End threads");

//--------------------------------------------------------------------
} catch (PThrowable & exc) {
 cout<<"\ntsttoi2ring: Catched Exception \n"<<(string)typeid(exc).name() 
     <<" - Msg= "<<exc.Msg()<<endl;
} catch (const std::exception & sex) {
 cout<<"\ntsttoi2ring: Catched std::exception \n" 
     <<(string)typeid(sex).name()<<endl; 
} catch (...) {
 cout<<"\ntsttoi2ring: some other exception was caught ! "<<endl;
}
//--------------------------------------------------------------------

exit(0);
}
