// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi2ring.cc,v 1.6 2003-04-17 13:47:34 cecile Exp $

#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"
#include "toi2ring.h"
// La valeur "Pi" doit etre celle de smathconst.h a cause du test sur theta
#include "smathconst.h"

////////////////////////////////////////////////////////////////////////
Toi2RING::Toi2RING(long n)
  :totnscount(0), nRings(0)
{
  setNSamples(n);
}

Toi2RING::~Toi2RING()
{
}


////////////////////////////////////////////////////////////////////////
void Toi2RING::Print(::ostream & os)
{
}

////////////////////////////////////////////////////////////////////////
void Toi2RING::init() {
  cout << "Toi2RING::init" << endl;
  declareInput("Theta");     // input  index 0
  declareInput("Phi");       // input  index 1
  declareInput("Phase");     // input  index 2
  declareInput("Value");     // input  index 3
  declareOutput("Rvalue");   // output index 0
  declareOutput("WRvalue");  // output index 1
}

////////////////////////////////////////////////////////////////////////
void Toi2RING::run() {

long snb = getMinIn();
long sne = getMaxIn();
if(snb>sne) {
  cout<<"Toi2RING::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
  throw ParmError("Toi2RING::run() - Bad sample interval");
}

//---------------------------------------------------------
try {


uint_4 mSnRead=0, mSnFilled=0, BadCoorRange=0;
 int_8 Nrings=0,i;
 
 double phi_prec=-1.,ctheta_prec,cphi_prec;
 double phi,val,ctheta,cphi;

 double* r = new double[Nsamples];
 double* wr = new double[Nsamples];
 for(i=0;i<Nsamples;i++) {
   wr[i]=0;
   r[i]=0;
 }

 cout << "loop " << snb << " " << sne << endl;
 
for(int k=snb;k<=sne;k++) {

  uint_8 flg = 0;
  ctheta = getData(0,k);
  cphi = getData(1,k);
  phi = getData(2,k);
  val = getData(3,k);
  mSnRead++;

  i=(int)(phi*Nsamples/360.);
  r[i]+= val;
  wr[i]++;

  
  if(phi < phi_prec || k == sne){
    
    //  if (k==sne) { wfits.setNRings(Nrings); wwfits.setNRings(Nrings);}
    
    putData(0,Nrings*(Nsamples+2)+0,ctheta_prec);
    putData(1,Nrings*(Nsamples+2)+0,ctheta_prec);
    putData(0,Nrings*(Nsamples+2)+1,cphi_prec);
    putData(1,Nrings*(Nsamples+2)+1,cphi_prec);
    cout << Nsamples << " !@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" << endl;
    for(i=0;i<Nsamples;i++) {
      if(wr[i] == 0) r[i] = -999999.;
      else r[i] /= wr[i];
      
      putData(0,Nrings*(Nsamples+2)+2+i,r[i]);
      putData(1,Nrings*(Nsamples+2)+2+i,wr[i]);
      wr[i]=0;
      r[i]=0.;
    
    }
    
    Nrings++;    
    cout <<" Ring "<< Nrings << " written " << endl;
  }
  phi_prec=phi;
  ctheta_prec=ctheta;
  cphi_prec=cphi;
  totnscount++;
} 

cout<<"RING2Toi::run: Samples Read "<<mSnRead
    <<" Filled "<<mSnFilled
    <<" BadCoorRange="<<BadCoorRange<<endl;

//---------------------------------------------------------
} catch (PException & exc) {
  cout<<"Toi2RING: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}

return;                                                                            
}
