#ifndef JET_H_SEEN
#define JET_H_SEEN

#include "machdefs.h"

//========================================================
//   Test d'expression template sur tableaux 
//       Reza - Avril 2003
//========================================================

// ---------------------------------------------------
// -------- Classe Taille objet Matrice --------------
// ---------------------------------------------------
class MtxSize {
public:
  MtxSize() : nrow_(0), ncol_(0) { }
  MtxSize(MtxSize const & a) : nrow_(a.nrow_), ncol_(a.ncol_) { }
  MtxSize(sa_size_t nr, sa_size_t nc) { nrow_ = nr;  ncol_ = nc; } 
  ~MtxSize() {};
  void ReSize(const MtxSize  & a) { nrow_ = a.nrow_;  ncol_ = a.ncol_; } 
  bool CompareSize(const MtxSize & a) const ;
protected:
  sa_size_t nrow_, ncol_;
};


class JETEvaluator {
public:
  JETEvaluator() {}
  //  virtual ~JETEvaluator() {}
  virtual void EvaluateAll(AnyDataObj& dest) const = 0;
  /*
  { throw PError("JETEvaluator::EvaluateAll(AnyDataObj &) Unsupported operation"); }
  virtual void EvaluateAll(NDataBlock<T> & dest) const 
  { throw PError("JETEvaluator::EvaluateAll( &) Unsupported operation"); }
  */
};

// -------- Classe generique d'expression  --------------

template <class T, class E>
class JETExpression : public JETEvaluator {
public:
  JETExpression() : e_() { }
  JETExpression(E const & e) : e_(e) { }
  JETExpression( JETExpression<T, E> const & e) : e_(e.e_) { } 
  inline T EvaluateAndStep() const { return e_.EvaluateAndStep(); }
  inline MtxSize const & RefSize()  const { return e_.RefSize(); }
  inline void Reset() const { e_.Reset(); } 
  virtual void EvaluateAll(AnyDataObj& dest)  const;
  inline E & Expression() { return e_; }
protected:
  E e_;
};

// -------- Classe Expression+Constante  --------------

template <class T, class E>
class JETExprAddConst  {
public:
  JETExprAddConst(E e, T c) :  e_(e) , c_(c)  
  {   }
  JETExprAddConst(JETExprAddConst<T, E> const & a) : e_(a.e_), c_(a.c_) { } 

  inline T EvaluateAndStep() const { return (e_.EvaluateAndStep()+c_); }
  MtxSize const & RefSize() const { return e_.RefSize() ; }
  inline void Reset() const { e_.Reset();  }

protected:
  E e_;
  T c_;
};

// -------- Classe Expression*Constante  --------------

template <class T, class E>
class JETExprMulConst  {
public:
  JETExprMulConst(E e, T c) :  e_(e) , c_(c)  
  {   }
  JETExprMulConst(JETExprMulConst<T, E> const & a) : e_(a.e_), c_(a.c_) { } 

  inline T EvaluateAndStep() const { return (e_.EvaluateAndStep()*c_); }
  MtxSize const & RefSize() const { return e_.RefSize() ; }
  inline void Reset() const { e_.Reset();  }

protected:
  E e_;
  T c_;
};



// -------- Classe Expression+Expression  --------------
template <class T, class E1, class E2>
class JETExprAdd {
public:
  JETExprAdd(E1 e1, E2 e2) :
    e1_(e1) , e2_(e2)
  { 
    if (! e1.RefSize().CompareSize(e2.RefSize()) ) 
      throw SzMismatchError("JETExprAdd() Unequal matrix size");
  }
  JETExprAdd(JETExprAdd<T, E1, E2> const & a) : e1_(a.e1_), e2_(a.e2_) { }

  inline T EvaluateAndStep() const { return (e1_.EvaluateAndStep() + e2_.EvaluateAndStep()); }
  virtual MtxSize const & RefSize() const { return e1_.RefSize() ; }
  inline void Reset() const { e1_.Reset(); e2_.Reset(); }
protected:
  E1 e1_;
  E2 e2_;
};

// -------- Classe Expression*Expression  --------------
template <class T, class E1, class E2>
class JETExprMult {
public:
  JETExprMult(E1 e1, E2 e2) :
    e1_(e1) , e2_(e2)
  { 
    if (! e1.RefSize().CompareSize(e2.RefSize()) ) 
      throw SzMismatchError("JETExprAdd() Unequal matrix size");
  }
  JETExprMult(JETExprMult<T, E1, E2> const & a) : e1_(a.e1_), e2_(a.e2_) { }

  inline T EvaluateAndStep() const { return (e1_.EvaluateAndStep() * e2_.EvaluateAndStep()); }
  virtual MtxSize const & RefSize() const { return e1_.RefSize() ; }
  inline void Reset() const { e1_.Reset(); e2_.Reset(); }
protected:
  E1 e1_;
  E2 e2_;
};



//----- Definition operateur Expression + Cste
template <class T, class E> 
JETExpression< T, JETExprAddConst<T,E> > operator + 
  (JETExpression<T,E> e, T c) 
  { return  JETExpression< T, JETExprAddConst<T,E> > 
  (JETExprAddConst<T,E>(e.Expression(), c) ); }

template <class T, class E> 
JETExpression< T, JETExprAddConst<T,E> > operator + 
  (T c, JETExpression<T,E> e) 
  { return  JETExpression< T, JETExprAddConst<T,E> > 
  (JETExprAddConst<T,E>(e.Expression(), c) ); }

//----- Definition operateur Expression * Cste
template <class T, class E> 
JETExpression< T, JETExprMulConst<T,E> > operator * 
  (JETExpression<T,E> e, T c) 
  { return  JETExpression< T, JETExprMulConst<T,E> > 
  (JETExprMulConst<T,E>(e.Expression(), c) ); }

template <class T, class E> 
JETExpression< T, JETExprMulConst<T,E> > operator * 
  (T c, JETExpression<T,E> e) 
  { return  JETExpression< T, JETExprMulConst<T,E> > 
  (JETExprMulConst<T,E>(e.Expression(), c) ); }

//----- Definition operateur Expression + Expression
template <class T, class E1, class E2> 
JETExpression< T, JETExprAdd<T,E1, E2> > operator + 
  (JETExpression<T,E1> e1, JETExpression<T,E2> e2) 
  { return  JETExpression< T, JETExprAdd<T, E1, E2> > 
  (JETExprAdd<T,E1,E2>(e1.Expression(), e2.Expression()) ); }

//----- Definition operateur Expression * Expression
template <class T, class E1, class E2> 
JETExpression< T, JETExprMult<T,E1, E2> > operator * 
  (JETExpression<T,E1> e1, JETExpression<T,E2> e2) 
  { return  JETExpression< T, JETExprMult<T, E1, E2> > 
  (JETExprMult<T,E1,E2>(e1.Expression(), e2.Expression()) ); }

#endif

