
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


static clock_t CPUT0, CPUT;
static time_t ELT0, ELT;
 
 
/* Nouvelle-Fonction */
/*!
   \ingroup SysTools
   Initializes CPU and elapsed time timer (C function).
   The values of the CPU and elapsed time can then be printed 
   using \b PrtTim() 
*/
void finittim_(void)
{
CPUT0 = CPUT = clock();
ELT0 = ELT = time(NULL);
return;
}
 
/* Nouvelle-Fonction */
/*!
   \ingroup SysTools
   Prints the values of the CPU and elapsed time, since call to \b InitTim().
*/
void fprttim_(int * num)
{
float tcal,tcalt;
clock_t cput;
time_t elt;
int etm,etmt;
 
elt = time(NULL);  cput = clock();
tcalt = ( (float)(cput) - (float)(CPUT0) ) / (float)(CLOCKS_PER_SEC);
tcal = ( (float)(cput) - (float)(CPUT) ) / (float)(CLOCKS_PER_SEC);
etm = elt - ELT;
etmt = elt - ELT0;
printf("FPrtTim[%d] CPUTime: Total= %g  (Partial= %g) Sec. \n",
       *num, tcalt, tcal);
printf("ElapsedTime(hh:mm:ss): Total= %02d:%02d:%02d ",
       etmt/3600, (etmt%3600)/60, etmt%60);
printf(" (Partial= %02d:%02d:%02d)\n",
       etm/3600, (etm%3600)/60, etm%60);
 
ELT = elt;
CPUT = cput;
return;
}
