// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: piotoirdr.h,v 1.2 2003-04-24 13:22:26 aubourg Exp $

#ifndef PIOTOIRDR_H
#define PIOTOIRDR_H

#include "config.h"
#include "toiprocessor.h"
#include <vector>

#include "HL2_PIOLIB/PIOLib.h"

/* Missing from PIO headers... */
extern "C" {
PIOErr PIOFreeInfoTOI(
		      PIOSTRING       *FLGname,
		      PIOSTRING       *TOItype,       /* Input: TOI format */ 
		      PIOSTRING       *TOIname,       /* Input: TOI name list */ 
		      PIOLONG         *BeginIndx,     /* Input: first index */
		      PIOLONG         *EndIndx        /* Input: last index */ 
		      );

PIOLONG PIOReadFLG(
		   PIOLONG **MyDataTable,   /* Output: Data memory address */
		   PIOSTRING flagdef,      /* Input : flag definition */ 
		   PIOSTRING command,      /* Input : Output parameters */ 
		   PIOGroup *MyGroup       /* Input : opened group reference */
		   );

PIOErr PIODeleteFLG(
		    void *MyData, /* Input: Data memory address */
		    PIOGroup *MyGroup /* Input : opened group reference */
		    );
}
/* End missing */


class PIOTOIReader : public TOIProcessor {
public:
  PIOTOIReader(string group, string object, string flagdef="");
  ~PIOTOIReader();

  virtual void init();
  virtual void run();

protected:
  // Le C++ ne semble pas totalement implemente au 20/02/03 ???
  // PIObjectTOI* pioTOI;
  // on va faire du C pour le moment.
  PIOGroup* pioGroup;
  string group; // le "object" de PIOOpenTOI qui semble etre un group
  string object; // le "Objectname" de PIOReadTOI qui lui est un objet (?)
  string flagdef;
  int bufferSize;

  void readBounds();
};

#endif

