// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: piotoiwtr.cc,v 1.1 2003-04-24 13:22:26 aubourg Exp $

#include "piotoiwtr.h"

extern void fits_lock();
extern void fits_unlock();

PIOTOIWriter::PIOTOIWriter(string grp, string obj) {
  group = grp;
  object = obj;
  pioGroup = NULL;
}

PIOTOIWriter::~PIOTOIWriter() {
}

void PIOTOIWriter::init() {
  fits_lock();
  pioGroup = PIOOpenTOI(const_cast<char*>(group.c_str()), "w");
  int err = PIOCreateTOIObject(const_cast<char*>(object.c_str()),
			       "PIODOUBLE",
			       pioGroup);
  fits_unlock();
  bufferSize = 1000;
  cout << "PIOTOIWriter : opened " << group << endl;
  declareInput(object); // Un seul, fourni lors de la creation
}

void PIOTOIWriter::run() {
  cout << "piotoiwriter run " << group << "[" << object << "] " 
       << snBegin << " " << snEnd << endl;

  double* data = new double[bufferSize];
  for (int snb = snBegin; snb <= snEnd; snb += bufferSize) {
    int sne = snb + bufferSize - 1;
    if (sne > snEnd) sne=snEnd;
    char command[80];
    sprintf(command, "Begin=%d; End=%d", snb, sne);    
    getData(0, snb, sne-snb+1, data);
    fits_lock();
    PIOLONG tableSize = PIOWriteTOI(data,
			    const_cast<char*>(object.c_str()),
			    "PIODOUBLE",
			    command,
			    pioGroup);
    fits_unlock();
  }
  delete[] data;
  fits_lock();
  PIOCloseTOI(pioGroup);
  fits_unlock();
}

  
  
