#include <string>
#include <iostream>

#include "toi.h"
#include "toisegment.h"
#include "toiprocessor.h"
#include "fitstoiwtr.h"
#include "piotoirdr.h"
#include "toimanager.h"

void usage() {
  cout << "usage: piotoi2fits group object fits_file toiname begin end";
  exit(-1);
}

int main(int argc, char** argv) {
  if (argc != 7) usage();

  string group  = argv[1];
  string object = argv[2];
  string fitsfn = argv[3];
  string toi    = argv[4];
  int begsn = atoi(argv[5]);
  int endsn = atoi(argv[6]);

  TOIManager* mgr = TOIManager::getManager();

  FITSTOIWriter wtr(fitsfn);
  PIOTOIReader rdr(group, object);
  
  mgr->connect(rdr, object, wtr, toi);

  rdr.setRequestedSample(begsn, endsn);

  mgr->startAll();

  mgr->waitForAll();
}
