#include <string>
#include <iostream> 

#include "toi.h"
#include "toisegment.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "piotoiwtr.h"
#include "toimanager.h"

void usage() {
  cout << "usage: fits2piotoi fits_file toiname group object begin end";
  exit(-1);
}


int main(int argc, char** argv) {
  if (argc != 7) usage();

  string fitsfn = argv[1];
  string toi    = argv[2];
  string group  = argv[3];
  string object = argv[4];
  int begsn = atoi(argv[5]);
  int endsn = atoi(argv[6]);

  TOIManager* mgr = TOIManager::getManager();

  FITSTOIReader rdr(fitsfn);
  PIOTOIWriter wtr(group, object);

  mgr->connect(rdr, toi, wtr, object);

  rdr.setRequestedSample(begsn, endsn);

  mgr->startAll();

  mgr->waitForAll();

}
