// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: ring2cout.cc,v 1.6 2003-04-24 13:33:05 aubourg Exp $

#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"
#include "ring2cout.h"
// La valeur "Pi" doit etre celle de smathconst.h a cause du test sur theta
#include "smathconst.h"

////////////////////////////////////////////////////////////////////////
Ring2cout::Ring2cout(long ns, long nr)
  :totnscount(0)
{
  setNSamples(ns);
  setNRings(nr);
}

Ring2cout::~Ring2cout()
{
}


////////////////////////////////////////////////////////////////////////
void Ring2cout::Print(::ostream & os)
{
}

////////////////////////////////////////////////////////////////////////
void Ring2cout::init() {
  cout << "Ring2cout::init" << endl;
  declareInput("Phase");     // input  index 0
}

////////////////////////////////////////////////////////////////////////
void Ring2cout::run() {

//---------------------------------------------------------
  double* val=NULL;
try {
  uint_4 mSnRead=0, mSnFilled=0, BadCoorRange=0;

  cout << " ring " << Nrings << " ns " << Nsamples<< endl;
  val = new double[Nsamples];
  for (int k=0; k<Nrings; k++) {
    
    double theta= getData(0,k*(Nsamples+2)+0);
    double phi  = getData(0,k*(Nsamples+2)+1);
    cout << Nrings << " " << k <<" " <<theta <<" " <<phi<< endl;
    getData(0,k*(Nsamples+2)+2,Nsamples,val);
    mSnRead ++;
    
    for (int i=0; i< Nsamples;i++)
      cout <<  i << " " << val[i]<< endl;
    totnscount+=Nsamples+2;
    
  }
 
  cout<<"RING2cout::run: Samples Read "<<mSnRead
      <<" Filled "<<mSnFilled
      <<" BadCoorRange="<<BadCoorRange<<endl;
  
  //---------------------------------------------------------
} catch (PException & exc) {
  cout<<"Ring2cout: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}

 delete[] val; 
 

 return;
}


















