// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: ringphase.h,v 1.1 2003-05-19 23:31:29 aubourg Exp $

#ifndef RINGPHASE_H
#define RINGPHASE_H

#include "config.h"
using namespace std;

#ifdef WITH_SOPHYA
#include "array.h"
#include "pexceptions.h"
using namespace SOPHYA;
#else
#include "apexceptions.h"
#endif

class RingPhase {
public:
  virtual ~RingPhase() {};

  virtual int getNSamples() const = 0;
  virtual double getPhase(int i) const = 0;

};

class SimpleRingPhase : public RingPhase {
public:
  SimpleRingPhase(int nsamples) : n(nsamples) {}
  
  int getNSamples() const {return n;}
  double getPhase(int i) const {return (double)i / n;}
  
protected:
  int n;
};

#endif
