// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: ring.h,v 1.1 2003-05-19 23:31:29 aubourg Exp $

#ifndef RING_H
#define RING_H

#include "config.h"
using namespace std;

#ifdef WITH_SOPHYA
#include "array.h"
#include "pexceptions.h"
using namespace SOPHYA;
#else
#include "apexceptions.h"
#endif

class RingProcessor;
class RingPhase;

class Ring {
public:
  Ring(int nsamples, double theta, double phi, double aperture, RingPhase* phinfo = NULL);
  virtual ~Ring();

  void setData(double* data);
  void setData(int i, double data);
  
  const double* getData() const; 
  double getData(int i) const;

  int getNSamples() const {return n;}
  double getTheta() const {return theta;}
  double getPhi() const {return phi;}
  double getAperture() const {return aperture;}

  
protected:
  int n;
  double theta;
  double phi;
  double aperture;
  RingPhase* ringPhase;
  bool ownRingPhase;
  double* data;
};
  
  
#endif

