// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: ringpipe.h,v 1.1 2003-05-19 23:31:29 aubourg Exp $

#ifndef RINGPIPE_H
#define RINGPIPE_H

#include "config.h"

#include <vector>

#include <pthread.h>

class RingProcessor;
class Ring;

class RingPipe {
public:
  RingPipe();
  virtual ~RingPipe();

  virtual Ring const* getRing(int i);
  virtual void putRing(int i, Ring const* ring);

  virtual void wontNeedRingBefore(int i);

protected:
  pthread_mutex_t       mutex;
  pthread_mutexattr_t   mutattr;
  pthread_cond_t        ringReady;
  
  RingProcessor* producer;
  vector<RingProcessor*> consumers;

  virtual void          setProducer(RingProcessor* prod);
  virtual void          addConsumer(RingProcessor* prod);

  friend class RingProcessor;

  void lock() {pthread_mutex_lock(&mutex);}
  void unlock() {pthread_mutex_unlock(&mutex);}
  void wait() {pthread_cond_wait(&ringReady, &mutex);}
  void notify() {pthread_cond_broadcast(&ringReady);}

  vector<Ring const*> data;
  int i0;

  enum DataStatus {DATA_OK=0, DATA_DELETED, DATA_NOT_YET};

  virtual void waitForRing(int i); // should be locked before
  virtual DataStatus isRingAvail(int i);  // should be locked before

  virtual void getRingRange(int& min, int& max);
};


#endif

