// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: ring.cc,v 1.1 2003-05-19 23:31:29 aubourg Exp $

#include "ring.h"
#include "ringphase.h"

Ring::Ring(int ns, double th, double p, double ap, RingPhase* rp) 
  : n(ns), theta(th), phi(p), aperture(ap), ringPhase(rp), ownRingPhase(false), data(new double[ns])
{
  if (ringPhase == NULL) {
    ringPhase = new SimpleRingPhase(n);
    ownRingPhase = true;
  }
}

Ring::~Ring() {
  if (ownRingPhase) delete ringPhase;
  delete[] data;
}

void Ring::setData(double* d) {
  memcpy(data, d, n*sizeof(double));
}

void Ring::setData(int i, double d) {
  data[i] = d;
}

const double* Ring::getData() const {
  return data;
}

double Ring::getData(int i) const {
  return data[i];
}

