// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: ringprocessor.h,v 1.2 2003-05-20 10:10:09 aubourg Exp $



#ifndef RINGPROCESSOR_H
#define RINGPROCESSOR_H


#include "config.h"

#include <pthread.h>
#include <string>
#include <map>

class Ring;
class RingPipe;

class RingProcessor {
public:
  RingProcessor();
  virtual ~RingProcessor();
  virtual void init();
protected:
  int declareRingInput(string ring);
  int declareRingOutput(string ring);

  void chkinit() {
    if (!inited) {init(); afterinit(); inited=true;}
  }
  bool inited;
  virtual void afterinit();

public:
  virtual void run();

  virtual int getMinRingIndex();
  virtual int getMaxRingIndex();
  virtual void setRingRange(int min, int max) {ringBegin=min; ringEnd=max;}

  virtual void addRingInput(string name, RingPipe* ring);
  virtual void addRingOutput(string name, RingPipe* ring);

  virtual void start();
  virtual void setName(string n) {name=n;}

  virtual int getWontNeedBefore() {return wontNeedRing;}

  virtual void setNeededRingHistory(int nrings); // -1 : disable
  
protected:
  virtual Ring const* getRing(int index, int i); // le ring sera desalloue par le systeme
  virtual void        putRing(int index, int i, Ring const*); // le ring a ete alloue par new, il sera gere
                                                              // par le systeme.

  RingPipe*        getInputRing(int index);
  RingPipe*        getOutputRing(int index);
  RingPipe*        getOutRing(string out);
  virtual void wontNeedRingBefore(int i);  
  friend class RingPipe;
  friend class TOIManager;
  virtual void getRingRange(int& min, int& max);


  int ringBegin;
  int ringEnd;
  int wontNeedRing;
  int neededRingHistory;

  void autoWontNeedRing(int iCur);
  int lastAWNR;

  map<string, int> inRingIx;
  map<string, int> outRingIx;

  RingPipe** inRings;
  RingPipe** outRings;

  string name;

  pthread_t        thread;

  static void* ThreadStart(void *);
};
#endif
