#include <unistd.h>
#include "toi.h"
#include "cgt.h"
#include "toiprocessor.h"
#include "toimanager.h"
#ifdef TOISEQBUFFERED
#include "toiseqbuff.h"
#else
#include "toisegment.h"
#endif

#include "sambainit.h"
#include "timing.h"
#include <stdexcept>
#include "ring.h"
#include "ringpipe.h"
#include "ringprocessor.h"

////////////////////////////////////////////////////////////////
// Le INCLUDE de la classe du processeur (peut etre mis a part)
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
class CreateRing : public RingProcessor {
public:
  CreateRing(int nsamples, double theta, double phi, double aperture);
  virtual ~CreateRing();

  virtual void	init(void);
  virtual void	run(void);

  void PrintStatus(::ostream & os);

  inline int_8 ProcessedSampleCount() const {return totnscount;}
protected:
  Ring r;
  int_8 nread,nwrite,totnscount;
};

CreateRing::CreateRing(int nsamples, double theta, double phi, double aperture)
: r(nsamples,theta,phi,aperture),nread(0), nwrite(0),totnscount(0)
{
}

CreateRing::~CreateRing()
{
}

void CreateRing::PrintStatus(::ostream & os)
{
  os<<"CreateRing::Print -- nread  = "<<nread<<endl
    <<"                -- nwrite = "<<nwrite<<endl;
}

void CreateRing::init() {
//  - 2 ringprocessors qui fabriquent des rings de bruit
//  - 1 ringprocessor qui les ajoute
//  - 1 ring processor qui les affiche



 // Declaration des tuyaux a connecter. L'ordre de declaration compte!
 cout << "CreateRing::init" << endl;
 declareRingOutput("sortie_bolo");  // output index 0
}

void CreateRing::run()
{

 // Verification des connections en sortie
 if(!getOutputRing(0) ) {
   cout<<"CreateRing::run() - Output TOI (boloSum/Mul) not connected! "<<endl;
   throw ParmError("CreateRing::run() Output TOI (boloSum/Mul) not connected!");
 }

 //---------------------------------------------------------

 for(int k=0;k<=r.getNSamples();k++) {
   totnscount++;
   r.setData(k,0.1*k);
   nwrite++;
   putRing(0,k,&r);
 }

 cout<<"CreateRing::run: end"<<endl;
}

////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////


class AddRing : public RingProcessor {
public:
  AddRing(void);
  virtual ~AddRing();

  virtual void	init(void);
  virtual void	run(void);

  void PrintStatus(::ostream & os);

  inline int_8 ProcessedSampleCount() const {return totnscount;}
protected:
  int_8 nread,nwrite,totnscount;
};

////////////////////////////////////////////////////////////////
// Le code de la classe du processeur (peut etre mis a part)
AddRing::AddRing(void)
: nread(0), nwrite(0),totnscount(0)
{
}

AddRing::~AddRing()
{
}

void AddRing::PrintStatus(::ostream & os)
{
  os<<"AddRing::Print -- nread  = "<<nread<<endl
    <<"                -- nwrite = "<<nwrite<<endl;
}

void AddRing::init() {
//  - 2 ringprocessors qui fabriquent des rings de bruit
//  - 1 ringprocessor qui les ajoute
//  - 1 ring processor qui les affiche



 // Declaration des tuyaux a connecter. L'ordre de declaration compte!
 cout << "AddRing::init" << endl;
 declareRingInput("entree_bolo_1");     // input  index 0
 declareRingInput("entree_bolo_2");     // input  index 1
 declareRingOutput("sortie_bolo_sum");  // output index 0
}

void AddRing::run()
{
//   // Verification des connections en entree
 if(!getInputRing(0) || !getInputRing(1) ) {
   cout<<"AddRing::run() - Input TOI (entree_bolo_1/2/3) not connected! "<<endl;
   throw ParmError("AddRing::run() Output TOI (entree_bolo_1/2/3) not connected!");
 }

 // Verification des connections en sortie
 if(!getOutputRing(0) ) {
   cout<<"AddRing::run() - Output TOI (boloSum/Mul) not connected! "<<endl;
   throw ParmError("AddRing::run() Output TOI (boloSum/Mul) not connected!");
 }

 // On recupere les sample numbers
 int snb,sne;
 getRingRange(snb,sne);
 
 cout<<"AddRing::run: sn="<<snb<<" sne="<<sne<<endl;
 if(snb>sne) {
   cout<<"AddRing::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
   throw ParmError("AddRing::run() - Bad sample interval ");
 }

 //---------------------------------------------------------
 Ring const *r1,*r2;
 

 for(int k=snb;k<=sne;k++) {
   totnscount++;

   r1 = getRing(0,k);
   r2 = getRing(1,k);
   nread++;


   putRing(0,k,r1.getData(k)+r2.getData(k));
   nwrite++;
 }
 cout<<"AddRing::run: end"<<endl;
}



////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
class PrintRing : public RingProcessor {
public:
  PrintRing();
  virtual ~PrintRing();

  virtual void	init(void);
  virtual void	run(void);

  void PrintStatus(::ostream & os);

  inline int_8 ProcessedSampleCount() const {return totnscount;}
protected:
  int_8 nread,nwrite,totnscount;
};

PrintRing::PrintRing()
: nread(0), nwrite(0),totnscount(0)
{
}

PrintRing::~PrintRing()
{
}

void PrintRing::PrintStatus(::ostream & os)
{
  os<<"PrintRing::Print -- nread  = "<<nread<<endl
    <<"                -- nwrite = "<<nwrite<<endl;
}

void PrintRing::init() {
//  - 2 ringprocessors qui fabriquent des rings de bruit
//  - 1 ringprocessor qui les ajoute
//  - 1 ring processor qui les affiche



 // Declaration des tuyaux a connecter. L'ordre de declaration compte!
 cout << "PrintRing::init" << endl;
 declareRingInput("entree_bolo");  // output index 0
}

void PrintRing::run()
{

 // Verification des connections en sortie
 if(!getInputRing(0) ) {
   cout<<"PrintRing::run() - Input TOI  not connected! "<<endl;
   throw ParmError("PrintRing::run() Input TOI  not connected!");
 }

 //---------------------------------------------------------
 int min,max;
 getRingRange(min,max);

 for(int k=min;k<=max;k++) {
   totnscount++;
   cout << k << " " << getRing(0,k);
   nwrite++;
 }
 cout<<"PrintRing::run: end"<<endl;
}


////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
void usage(void);
void usage(void) {
  cout<<"tstringpipe  ";
   cout<<" "<<endl;
 return;
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg) {

TOIManager* mgr = TOIManager::getManager();

//-- Decodage arguments

SophyaInit();
InitTim();

//--------------------------------------------------------------------
try {
//--------------------------------------------------------------------
  
//  bool fgsegmented = true;
//  int wsize = 512;
//    CGT plombier(fgsegmented,wsize);
//    plombier.SetDebugLevel(99);

 // FITS reader et writer
 int nsamples=1024;
 
 double theta = 12.;
 double phi = 0.;
 double aperture = 85.;
 CreateRing cr1(nsamples,theta,phi,aperture);
 CreateRing cr2(nsamples,theta,phi,aperture);
 AddRing addring();
 PrintRing p();

 RingPipe *ring1;
 RingPipe *ring2;
 RingPipe *ring3;
 cr1.addRingOutput("sortie_bolo", ring1);
 cr2.addRingOutput("sortie_bolo", ring2);
 addring.addRingInput("entree_bolo_1",ring1);
 addring.addRingInput("entree_bolo_2",ring2);
 addring.addRingOutput("sortie_bolo_sum",ring3);
 p.addRingInput("entree_bolo",ring3);

 cr1.start();
 cr2.start();
 addring.start();
 p.start();
 
//   plombier.Connect(cr1,"sortie_bolo",AddRing,"entree_bolo_1");
//   plombier.Connect(cr2,"sortie_bolo",AddRing,"entree_bolo_2");
//   plombier.Connect(AddRing,"sortie_bolo_sum",PrintRing,"entree_bolo");
//   plombier.Start();
//   plombier.ListTOIs(cout, 1);
 cout << "Joining ..." << endl;

 mgr->joinAll();
 PrtTim("End threads");

//--------------------------------------------------------------------
} catch (PThrowable & exc) {
 cout<<"\ntsttoi2ring: Catched Exception \n"<<(string)typeid(exc).name() 
     <<" - Msg= "<<exc.Msg()<<endl;
} catch (const std::exception & sex) {
 cout<<"\ntsttoi2ring: Catched std::exception \n" 
     <<(string)typeid(sex).name()<<endl; 
} catch (...) {
 cout<<"\ntsttoi2ring: some other exception was caught ! "<<endl;
}
//--------------------------------------------------------------------

exit(0);
}
