// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: piotoirdr.cc,v 1.10 2003-06-05 08:15:47 aubourg Exp $

#include "piotoirdr.h"

extern void fits_lock();
extern void fits_unlock();

//char** environ; // For darwin dylibs with piolib

PIOTOIReader::PIOTOIReader(string grp, string obj, string flg) {
  group = grp;
  object = obj;
  flagdef = flg;
  pioGroup = NULL;

}

PIOTOIReader::~PIOTOIReader() {
  if (pioGroup != NULL) {
    // ??
  }
}

void PIOTOIReader::init() {
  fits_lock();
  char groupname[128];
  strcpy(groupname, group.c_str());
  pioGroup = PIOOpenTOI(groupname, "r");
  
  if (pioGroup == NULL) {
    cerr << " ERROR in PIOOpenTOI cannnot open " << groupname << endl;
    abort();
  }
  fits_unlock();
  cout << "pioGroup : "<< pioGroup << endl;
  readBounds();
  bufferSize = 1000;
  cout << "PIOTOIReader : opened " << groupname
       << " " <<  snBegin << " - " << snEnd << ": " << pioGroup << endl;
  if (flagdef != "") {
    cout << "   with flagdef = " << flagdef << endl;
  }

  declareOutput(object);
}

void PIOTOIReader::readBounds() {
  PIOSTRING* flgName;
  PIOINT     nbFlg;
  PIOSTRING* toiType;
  PIOSTRING* toiName;
  PIOLONG*   beginIndex;
  PIOLONG*   endIndex;
  PIOINT     nbTOI;
  PIOSTRING  ROIGroup;

  fits_lock();
  PIOInfoTOI(&flgName,
	     &nbFlg,
	     &toiType,
	     &toiName,
	     &beginIndex,
	     &endIndex,
	     &nbTOI,
	     ROIGroup,
	     pioGroup);

  // On recupere un tableau de beginIndex, il faut retrouver celui qui nous concerne
  for (int i=0; i<nbTOI; i++) {
    cout << toiName[i] << endl;
    if (object == toiName[i]) {
      snBegin = beginIndex[i];
      snEnd   = endIndex[i];
      cout << snBegin << " " << snEnd << endl;
      break;
    }
  }

  PIOFreeInfoTOI(flgName,
		 toiType,
		 toiName,
		 beginIndex,
		 endIndex);
  fits_unlock();
}

void PIOTOIReader::run() {
  cout << "PIOTOIReader run " << group << "[" << object << "] " 
       << snBegin << " " << snEnd << endl;

  for (int snb = snBegin; snb <= snEnd; snb += bufferSize) {
    int sne = snb + bufferSize - 1;
    if (sne > snEnd) sne=snEnd;
    // TBD : check if PIODOUBLE != double;
    char command[80];
    sprintf(command, "Begin=%d; End=%d", snb, sne);
    double* data = NULL;
    uint_8*   flags = NULL;
    PIOBYTE*  pioflags = NULL;
    fits_lock();
    PIOLONG n = PIOReadTOI((void**) &data,
			   const_cast<char*>(object.c_str()),
			   "PIODOUBLE",
			   command,
			   pioGroup);
    if ( n<0) {
      cout << " PIOReadTOI : " << n << endl;
      abort();
    }
    if (flagdef != "") {
      PIOLONG nf = PIOReadFLGObjectMask(&pioflags,
				       const_cast<char*>(flagdef.c_str()),
				       command,
				       pioGroup);
      if (nf != n) {
	cerr << "*** PIO Error, inconsistent read, data " << n << " flags " 
	     << nf << endl;
	abort();
      }
      flags = new uint_8[nf];
      for (int i=0; i<nf; i++) flags[i] = (uint_8)pioflags[i];
      PIODeleteFLG(pioflags, pioGroup);
    }
    fits_unlock();
    

    if (flags != NULL) {
      putData(0, snb, sne-snb+1, data, flags);
    } else {
      putData(0, snb, sne-snb+1, data);
    }
    
    fits_lock();
    PIODeleteTOI(data, pioGroup);
    //    if (flags != NULL) PIODeleteFLG(flags, pioGroup); // PB !
    if (flags != NULL) delete[] flags;
    fits_unlock();
  }
  PIOCloseTOI(pioGroup);
}
