// This may look like C code, but it is really -*- C++ -*-
#ifndef MINUITADAPT_SEEN
#define MINUITADAPT_SEEN

#include "machdefs.h"
#include "tvector.h"
#include "tmatrix.h"

namespace SOPHYA {

class MinuitAdapt {
public:
  MinuitAdapt(void (*myfcn)(int_4 *,double *,double *,double *,int_4 *,double (*f)(double *))
             ,double (*myfutils)(double *)=NULL);
  virtual ~MinuitAdapt(void);

  void SetTitle(char* title);
  void Clear(void);
  void Return(void);

  void PrintLevel(int_4 n=1);
  void SetWidthPage(int_4 n=120);
  void SetWarnings(bool w=true);
  void SetErrorDef(double err=1.);
  void SetEpsMachine(double eps=1.e-13);
  void SetStrategy(int_4 n=1);
  void SetGradient(int_4 n=-1);
  void SetRandom(int_4 seed);

  void DefineParameter(int_4 n,char* name,double init,double step
                      ,double vmin=0.,double vmax=0.);
  void SetParameter(int_4 n,double val);
  void SetLimits(int_4 n,double val1=0.,double val2=0.);
  void SetFix(int_4 n);
  void Release(int_4 n);
  void Restore(bool only_last_fixed=false);

  void DoFit(char *method="MIGRAD",int_4 maxcall=9999999,double tol=0.1);
  inline void Migrad(int_4 maxcall=9999999,double tol=0.1)
       {DoFit("MIGRAD",maxcall,tol);}
  inline void Minimize(int_4 maxcall=-1,double tol=0.1)
       {DoFit("MINIMIZE",maxcall,tol);}
  inline void Simplex(int_4 maxcall=9999999,double tol=0.1)
       {DoFit("SIMPLEX",maxcall,tol);}
  void Improve(int_4 maxcall=9999999);
  void Hesse(int_4 maxcall=9999999);
  void Minos(int_4 maxcall=9999999);
  void Seek(int_4 maxcall=9999999,double stdev=3.);

  void Call(int_4 iflag);
  void DrawContour(int_4 n1,int_4 n2,int_4 npts=25);
  int_4 GetContour(int_4 n1,int_4 n2,int_4 npts
                  ,TVector<r_8>& xpt,TVector<r_8>& ypt);
  void Scan(int_4 n,double from,double to,int_4 npts=25);

  void ShowParameter(void);
  void ShowRandom(void);
  void ShowFcnValue(void);
  void ShowCovariance(void);
  void ShowCorrelations(void);
  void ShowEigenValues(void);

  inline int_4 NPar(void) {return mNPar;}
  inline int_4 ErrFlag(void) {return iErFlg;}
  void GetParameter(int_4 n,string& name,double& val,double& err
                   ,double& bound1,double& bound2,int_4& ivarbl);
  void GetErrors(int_4 n,double& eplus,double& eminus
                ,double& eparab,double& globcc);
  TMatrix<r_8> GetErrorsMatrix(void);

protected:
  int_4 mNPar,iErFlg;
  void (*fcn)(int_4 *,double *,double *,double *,int_4 *,double (*f)(double *));
  double (*futils)(double *);
};

} // Fin du namespace

#endif
