// This may look like C code, but it is really -*- C++ -*-
//
// $Id: ctimer.h,v 1.2 1999-04-21 13:12:00 ansari Exp $
//


#ifndef CTIMER_SEEN
#define CTIMER_SEEN

#include <sys/types.h>
#include <time.h>
#include <iostream.h>
#include <stdio.h>
#include "machdefs.h"

// <summary> Permet de chronometrer des fonctions. </summary>
// La macro TIMEF cree un objet de class Timer qui memorise
// l'heure de sa creation, et le temps CPU.

// A la fin du bloc ou de la procedure, l'objet est detruit,
// et son destructeur affiche le temps ecoule.

// La macro SPLITTIME lui permet d'afficher des temps partiels.
class Timer  {
public:
  // L'objet memorise le temps CPU et l'heure, et le nom donne
  Timer(const char* name=0);

  // Le destructeur appelle split sans parametre.
  virtual ~Timer();

  // Affiche le temps ecoule total/partiel, avec le nom eventuel.
  // Si pas de parametre affiche le nom donne a la creation.
  void Split(const char* comm=0);

  // Sert a eviter que GNU ne pretende qu'on utilise pas l'objet...
  void Nop() {}

private:
  clock_t cpu0, cpuSplit;
  time_t  elapse0, elapseSplit;
  const char* timerName;
};

#define TIMEN(x)  Timer timer(x); timer.Nop();
#define TIMEF     Timer timer(__PRETTY_FUNCTION__); timer.Nop();
#define SPLITTIME timer.Split();

#endif // CTIMER_SEEN
