#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>
#include <fstream>

using namespace std;

int tstseqwrite();
int tstseqread();
int tstseekbegread();
int tstseekendread();

// -----------------------------------------------------
// This test program illustrates the problem with g++
//  (pb with g++ 2.95 3.0) 
// iostream library with seekg(..., ios::end)
//         R. Ansari (LAL/IN2P3-CNRS) - April 2002
//
// # compile the program 
// csh> g++ -o pbseekios pbseekios.cc
// # Run the program, check the output and the return code
// # Read with seekg(... ios::end) ---> wrong result (tstseekendread())
// # while seekg(... ios::beg) works OK (tstseekbegread())
// csh> ./pbseekios 
// September 2003
// The problem with seekg(... ios::end) seems to be solved 
// with gcc 3.1, 
// However, on MacOSX 10.2, with gcc 3.1, reading the last byte of
// a file causes an error and stream can not be positionned anymore
// ----------------------------------------------------

int main(int narg, char ** arg)
{

  int rc;
  rc = tstseqwrite();
  rc += tstseqread();
  rc += tstseekbegread();
  rc += tstseekendread();
  if (rc == 0) 
    cout << "--- End of pbseekios - OK (Rc=0) " << endl;
  else 
    cout << "--- End of pbseekios - ERRORS (Rc= " << rc << ")" << endl;
  return (rc);
}

// ------ Test function to write sequentially to a ofstream ------
int tstseqwrite()
{
  int i;
  int iv;
  float fv;
  char * flnm = "pbseekios.dat";
 ofstream os(flnm, ios::out | ios::binary);  
  cout << ">>>> tstseqwrite() - Sequential writing to file " << flnm << endl; 
  //  ofstream os(flnm, ios::out );  
  for(i=0; i<7; i++) {
    iv = 1000+i*10;
    fv = iv+0.5;
    os.write((char const*)(&iv), sizeof(int));
    os.write((char const*)(&fv), sizeof(float));
  }
  return(0);
}

// ------ Test function to read sequentially from a ifstream ------
int tstseqread()
{
  int i;
  int iv,iv0;;
  float fv, fv0;
  long pos;
  char * flnm = "pbseekios.dat";
// is = new ifstream(flnm, ios::in | ios::binary);
  ifstream is(flnm, ios::in );
  cout << ">>>> tstseqread() - Sequential reading from file " << flnm << endl; 
  int rc = 0;
  for(i=0; i<7; i++) {
    iv0 = 1000+i*10;
    fv0 = iv0 + 0.5;
    iv = 0;  fv = 0.;
    pos = is.tellg();
    is.read((char *)(&iv), sizeof(int));
    is.read((char *)(&fv), sizeof(float));
    cout << "Read@" << i << " : Pos= " << pos << " IV=" << iv 
	 << " FV= " << fv << " Expect:(" 
	 << iv0 << "," << fv0 << ")" 
	 << " ->NewPos="<< is.tellg() << endl;
    if (iv != iv0) rc++; 
  }
  if (rc == 0) 
    cout << " tstseqread() OK , Rc= 0 " << endl;
  else
    cout << " tstseqread() ERROR , Rc=  " << rc << endl;
  return rc;
}

// ------ Random access read from a ifstream seek(ios::beg) ------
int tstseekbegread()
{
  int i;
  int num[7] = {2,4,1,6,5,3,0};
  int iv,iv0;
  float fv,fv0;
  long pos;
  char * flnm = "pbseekios.dat";
// is = new ifstream(flnm, ios::in | ios::binary);
  ifstream is(flnm, ios::in );
  cout << ">>>> tstseekbegread() - Random access reading from file " 
       << flnm << " (seekg(... ios::beg) " << endl; 
  int rc = 0;
  for(i=0; i<7; i++) {
    iv0 = 1000+num[i]*10;
    fv0 = iv0 + 0.5;
    iv = 0;  fv = 0.;
    is.seekg(num[i]*(sizeof(int)+sizeof(float)), ios::beg);
    pos = is.tellg();
    is.read((char *)(&iv), sizeof(int));
    is.read((char *)(&fv), sizeof(float));
    cout << "Read@" << num[i] << " : Pos= " << pos << " IV=" << iv 
	 << " FV= " << fv << " Expect:(" 
	 << iv0 << "," << fv0 << ")" 
	 << " ->NewPos="<< is.tellg() << endl;
    if (iv != iv0) rc++;
  }
  if (rc == 0) 
    cout << " tstseekbegread() OK , Rc= 0 " << endl;
  else
    cout << " tstseekbegread() ERROR , Rc=  " << rc << endl;
  return rc;
}

// ------ Random access read from a ifstream seek(ios::end) ------
int tstseekendread()
{
  int i;
  int num[7] = {2,4,1,6,5,3,0};
  int iv,iv0;
  float fv,fv0;
  long pos;
  char * flnm = "pbseekios.dat";
// is = new ifstream(flnm, ios::in | ios::binary);
  ifstream is(flnm, ios::in );
  cout << ">>>> tstseekendread() - Random access reading from file " 
       << flnm << " (seekg(... ios::end) " << endl; 
  int rc = 0;
  for(i=0; i<7; i++) {
    iv0 = 1000+num[i]*10;
    fv0 = iv0 + 0.5;
    iv = 0;  fv = 0.;
    is.seekg((num[i]-7)*(sizeof(int)+sizeof(float)), ios::end);
    pos = is.tellg();
    is.read((char *)(&iv), sizeof(int));
    is.read((char *)(&fv), sizeof(float));
    cout << "Read@" << num[i] << " : Pos= " << pos << " IV=" << iv 
	 << " FV= " << fv << " Expect:(" 
	 << iv0 << "," << fv0 << ")" 
	 << " ->NewPos="<< is.tellg() << endl;
    if (iv != iv0) rc++;
  }
  if (rc == 0) 
    cout << " tstseekendread() OK , Rc= 0 " << endl;
  else
    cout << " tstseekendread() ERROR , Rc=  " << rc << endl;
  return rc;
}

