// This may look like C code, but it is really -*- C++ -*-
// Fonctions d'ecriture de tableaux numeriques
#ifndef PIOCMPLX_H_SEEN
#define PIOCMPLX_H_SEEN

/*
// Pour gerer les Persist I/O de tableaux numerique templates
template <class T>
void PIOSReadArray(PInPersist & is, T* arr, size_t n);
template <class T>
void PIOSWriteArray(POutPersist & os, T const * arr, size_t n);
*/

// Pour pouvoir ecrire des tableau de complex, en attendant 
// PIn/POutPersist::Get/Put(complex<>)

inline
void PIOSReadArray(PInPersist & is, uint_1 * arr, size_t n)
{
is.GetBytes(arr, n);
}

inline
void PIOSReadArray(PInPersist & is, uint_2 * arr, size_t n)
{
is.Get(arr, n);
}

inline
void PIOSReadArray(PInPersist & is, int_2 * arr, size_t n)
{
is.Get(arr, n);
}

inline
void PIOSReadArray(PInPersist & is, uint_4 * arr, size_t n)
{
is.Get(arr, n);
}

inline
void PIOSReadArray(PInPersist & is, int_4 * arr, size_t n)
{
is.Get(arr, n);
}

inline
void PIOSReadArray(PInPersist & is, uint_8 * arr, size_t n)
{
is.Get(arr, n);
}

inline
void PIOSReadArray(PInPersist & is, int_8 * arr, size_t n)
{
is.Get(arr, n);
}

inline
void PIOSReadArray(PInPersist & is, r_4 * arr, size_t n)
{
is.Get(arr, n);
}

inline
void PIOSReadArray(PInPersist & is, r_8 * arr, size_t n)
{
is.Get(arr, n);
}

inline
void PIOSReadArray(PInPersist & is, complex<float> * arr, size_t n)
{
r_4 * pr = (r_4 *)arr;
is.Get(pr, n*2);
}

inline
void PIOSReadArray(PInPersist & is, complex<double> * arr, size_t n)
{
r_8 * pr = (r_8 *)arr;
is.Get(pr, n*2);
}

// Fonctions d ecriture de tableaux de nombre
inline
void PIOSWriteArray(POutPersist & os, uint_1 const * arr, size_t n)
{
os.PutBytes(arr, n);
}

inline
void PIOSWriteArray(POutPersist & os, uint_2 const * arr, size_t n)
{
os.Put(arr, n);
}

inline
void PIOSWriteArray(POutPersist & os, int_2 const * arr, size_t n)
{
os.Put(arr, n);
}

inline
void PIOSWriteArray(POutPersist & os, uint_4 const * arr, size_t n)
{
os.Put(arr, n);
}

inline
void PIOSWriteArray(POutPersist & os, int_4 const * arr, size_t n)
{
os.Put(arr, n);
}

inline
void PIOSWriteArray(POutPersist & os, uint_8 const * arr, size_t n)
{
os.Put(arr, n);
}

inline
void PIOSWriteArray(POutPersist & os, int_8 const * arr, size_t n)
{
os.Put(arr, n);
}

inline
void PIOSWriteArray(POutPersist & os, r_4 const * arr, size_t n)
{
os.Put(arr, n);
}

inline
void PIOSWriteArray(POutPersist & os, r_8 const * arr, size_t n)
{
os.Put(arr, n);
}

inline
void PIOSWriteArray(POutPersist & os, complex<float> const * arr, size_t n)
{
r_4 const * pr = (r_4 const *)arr;
os.Put(pr, n*2);
}

inline
void PIOSWriteArray(POutPersist & os, complex<double> const * arr, size_t n)
{
r_8 const * pr = (r_8 const *)arr;
os.Put(pr, n*2);
}

#endif
