// This may look like C code, but it is really -*- C++ -*-
// Tabulated math functions
//   E. Aubourg, C. Magneville  1996-2000
// DAPNIA/SPP (Saclay) / CEA    LAL - IN2P3/CNRS  (Orsay)

#ifndef TABMATH_H_SEEN
#define TABMATH_H_SEEN

#include <math.h>
#include "peida.h"
#include "nbconst.h"

namespace SOPHYA {  

///////////////////////////////
//  Exponentielles tabulees  //
///////////////////////////////

class TabFExp  {
public:
  TabFExp();
  ~TabFExp();
  inline double operator()(double x)
    { if (x > 0) return exp(x);
      if (x <= -10) return 0;
          return tab[int(-x*1000)];
    }
private:
  double* tab;
};

extern TabFExp* ptabFExp;
#define tabFExp(_x_) ((*ptabFExp)(_x_))


////////////////////////////////////
//    Sinus tabules (et Cosinus)  //
////////////////////////////////////

class TabFSin  {
public:
  TabFSin(int ntab = 0);
  ~TabFSin();
  inline double operator()(double x)
    {
    double s = 1.;
    if(x<0.) {x *=-1.; s = -1.;}
    x -= DeuxPi * int(x/DeuxPi);
    if(x>Pi) {x -= Pi; s *= -1.;}
    if(x>Pi/2.) x = Pi-x;
    return s * tab[int(x/delta)];
    }
private:
  int ntab;
  double delta;
  double* tab;
};

extern TabFSin* ptabFSin;
#define tabFSin(_x_) ((*ptabFSin)(_x_))
#define tabFCos(_x_) ((*ptabFSin)(_x_+Pis2))

} // namespace SOPHYA

#endif
