// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive  PIStackWindow  PIZoneWindow
//                             R. Ansari  08/98

#ifndef PISTZWIN_H_SEEN
#define PISTZWIN_H_SEEN

#include "pisysdep.h"
#include PIWIN_H
#include PIPERIODIC_H

// ----------------------- Classe PIStackLayout ----------------------------
// Pour Fenetre de type empilement , tout widget occupe la totalite 
// de la fenetre - Un seul des widget visible (active) a chaque moment

class PIStackLayout : public PILayoutMgr {
public:
		PIStackLayout();
  virtual 	~PIStackLayout();

  virtual void  ChildAdd(PIWdg* child);
  virtual void  ChildDel(PIWdg* child);

  inline PIWdg*  CurrentWdg() { return(GetChild(mCurdisp)); }
  inline int    NumCurrentWdg() { return(mCurdisp); } 
  virtual void  DispNext();
  virtual void  DispWdgNum(int n);

protected:
  int mCurdisp;
};
		
// ----------------------- Classe PIStackWindow ----------------------------
//                    Fenetre avec un PIStackLayout

class PIStackWindow : public PIWindow {
public:
		PIStackWindow(PIMsgHandler* par, const char* nom, PIWindowKind k=PIWK_normal,
                              int sx=100, int sy=100, int px=0, int py=0);
  virtual	~PIStackWindow();

  virtual void  SetLayoutMgr(PILayoutMgr* nlay);
  virtual void  PSPrint(PSFile *psf, int ofx=0, int ofy=0,
			double scale_x=1., double scale_y=1.);

  inline  void  DispNext() { ((PIStackLayout*)layout)->DispNext(); }
  inline  PIWdg* CurrentWdg() { return( ((PIStackLayout*)layout)->CurrentWdg() ); }

  virtual void  StartAutoDisp(int dtms=1000);
  virtual void  StopAutoDisp();

protected:
  PIPeriodic mPerad;
};

// ----------------------- Classe PIZoneLayout ----------------------------
// Pour fenetre avec nzx*nzy zone d affichage - Les nouveaux widgets dans chaque
// zone viennent remplacer les anciennes - Ceux-ci sont detruits automatiquement


class PIZoneLayout : public PILayoutMgr {
public:
		PIZoneLayout(int nzx=1, int nzy=1);
  virtual 	~PIZoneLayout();

  virtual void  ChildAdd(PIWdg* child);
  virtual void  ChildDel(PIWdg* child);
  virtual void  SetZone(int nzx, int nzy);
  virtual void  NbZone(int& nzx, int& nzy);
  virtual PIWdg* NextChildPosSize(int& px, int& py, int& sx, int& sy);

protected:
  int mZx, mZy, mZc;
  PIWdg** mZWdg;
};

// ----------------------- Classe PIZoneWindow ----------------------------
//                    Fenetre avec un PIZoneLayout 
 
class PIZoneWindow : public PIWindow {
public:
		PIZoneWindow(PIMsgHandler* par, const char* nom, PIWindowKind k=PIWK_normal,
                             int nzx=1, int nzy=1, int sx=100, int sy=100, int px=0, int py=0);
  virtual	~PIZoneWindow();

  virtual void  SetLayoutMgr(PILayoutMgr* nlay);

  inline  void  SetZone(int nzx, int nzy) { ((PIZoneLayout*)layout)->SetZone(nzx, nzy); }
  inline  void  NbZone(int& nzx, int& nzy)  { ((PIZoneLayout*)layout)->NbZone(nzx, nzy); }
  inline PIWdg* NextChildPosSize(int& px, int& py, int& sx, int& sy)
                { return ( ((PIZoneLayout*)layout)->NextChildPosSize(px, py, sx, sy) ); }

protected:
};

#endif
