#!/bin/csh

if( "$1" == "-h" ) then
  echo 'Placez vous dans le repertoire ou vous avez'
  echo 'mis le NOUVEAU code du libastro de Xephem.'
  echo '> $DPCSOURCE/XephemAstroLib/compare_with_xephem.csh'
  exit -1
endif

set dir = $DPCSOURCE/XephemAstroLib/
set log = `pwd`/compare.log

rm -f $log; touch $log

echo ======================= NOUVEAU REPERTOIRE >>& $log
ls *.h >>& $log
ls *.c >>& $log

echo ======================= REPERTOIRE $dir >>& $log
pushd $dir
ls *.h  >>& $log
ls *.c >>& $log
popd

echo ======================= INCLUDE >>& $log
foreach f ( *.h )
  echo ======================= $f >>& $log
  diff $f $dir/$f >>& $log
end

echo ======================= FICHIERS >>& $log
foreach f ( *.c )
  echo ======================= $f >>& $log
  diff $f $dir/$f >>& $log
end

echo "Resultat dans le fichier $log"

exit 0
