// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive PIDrawer3D PIDraw3DWdg
//      DrawWidget 3D       R. Ansari 06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIWDG3D_H_SEEN
#define PIWDG3D_H_SEEN

#include "pisysdep.h"
#include "pi3ddrw.h"

#include PIBWDG_H




//------------------------------ Classe PIDrawer3D --------------------

class PIDraw3DWdg : public PIBaseWdg {
public:
  enum {ClassId = 5500};

			PIDraw3DWdg(PIContainerGen *par, const char *nom,
                                    int sx=100, int sy=100, int px=0, int py=0);
  virtual		~PIDraw3DWdg();
  virtual long		kind() {return ClassId; }


  virtual void		Set3DView_Obs(double xo, double yo, double zo, double teta, double phi, double psi, 
                                      double dax, double day, double co, double dco=0.2);
  virtual void       	Set3DView(double xc, double yc, double zc, double xo, double yo, double zo, 
                                  double dax, double day, double dco=0.2, double psi=0.);
  bool           	Get3DView(double& xc, double& yc, double& zc, double& xo, double& yo, double& zo, 
                                  double& teta, double& phi, double& psi, double& dax, double& day, double& co, double& dco);

  virtual void          Update3DView();   // Vue 3-D a partir de Drawer No 1

  inline void	     	SetTitles(const char* tt=NULL, const char* tb=NULL)
                                  { mBDrw->SetTitles(tt, tb); }
  inline void	     	SetTitles(string const & tt, string const & tb)
                                  { mBDrw->SetTitles(tt, tb); }
  inline PIElDrawer3D*  BaseDrawer() { return mBDrw; };

//   Methode permettant de decoder des options a partir de chaines
  virtual int           DecodeOptionString(vector<string> & opt, bool rmdecopt=true);

// Ajoute un Drawer 
  int                   AddDrawer3D(PIDrawer3D*, bool ad=false);   

//  Pour tenir trace des Drawers-3D qui sont detruits 
  virtual void      	RemoveDrawer(int id);       
  virtual void       	DeleteDrawers();            

  virtual void		But1Press(int x, int y);

  virtual void		But2Press(int x, int y);
  virtual void		But2Release(int x, int y);
  virtual void		Ptr2Move(int x, int y);

  virtual void		But3Press(int x, int y);
  virtual void		But3Release(int x, int y);
  virtual void		Ptr3Move(int x, int y);

  virtual void 		Keyboard(int key, PIKeyModifier kmod);
  virtual void 		PasteSelection(unsigned int typ, void *pdata, unsigned int l);


protected :
  virtual void		SetDrawers3DView();
  virtual void		DrawXYZAxes();

  PIElDrawer3D* mBDrw;   // Objet traceur d'elements de fond
  int mPx, mPy;        // Position pointeur - Bouton-1 
  
  bool vfixed;       // SetView fait ou pas
  list<int> m3DrIl;  // Liste des Id drawers 3D 
  PIGraphic3D* mGr3d;   // PIGraphic3D courante
  int lPx, lPy;         // dernier position pointeur
  PIColors lCol;        // Couleur
  double cTeta, cPhi, cUlen;    // Pour garder valeurs avant rotation, Unite de longeur
  double cXc, cYc, cZc;         // Pour garder position du centre de champ 
  double clCO, cDax, cDay;      // Pour garder les valeurs avant Zoom In/Out
  bool  rOfg;                  // si Vrai  on fait tourner l'objet et pas la camera
  bool  axfg;                  // si Vrai on trace les axes
  bool  skcfg;                 // si Vrai click-2 au centre -> rotation objet
};

#endif
