#include "picontainerx.h"

#include <Xm/Form.h>

/* *** ATTENTION *** La constante ci-dessous PIXMFORMFRACBASE
   doit etre identique ds piwdgx.cc  picontainerx.cc et piwindowx.cc
   ***************************************************************** */
#define PIXMFORMFRACBASE 1000


/* --Methode-- */
PIContainerX::PIContainerX(PIContainerGen *par, const char *nom, 
                           int sx, int sy, int px, int py) 
: PIContainerGen(par, nom, sx, sy, px, py)
{
if ((sx > 0) && (sy > 0)) {
  CreateXtWdg(nom, xmFormWidgetClass , NULL, sx, sy, px, py);
  int fbase = PIXMFORMFRACBASE ;  // Valeur de XmNfractionBase des XmForm ds PIContainerX
  Arg  wargs[5];
  int n=0;
  XtSetArg(wargs[n],XmNfractionBase, fbase);  n++;
  XtSetArg(wargs[n],XmNhorizontalSpacing, 0);  n++;
  XtSetArg(wargs[n],XmNverticalSpacing, 0);  n++;
  XtSetValues(XtWdg(), wargs, n);
  }
//  CreateXtWdg(nom, xmBulletinBoardWidgetClass , NULL, sx, sy, px, py);
mTopWdg = NULL;
}

// constructeur special a utiliser par PIApplicationX ...
PIContainerX::PIContainerX(PIMsgHandler *par, PIWdgX *parwdg, const char *nom,  
                           int sx, int sy, int px, int py) 
: PIContainerGen(NULL, nom, sx, sy, px, py)
{
SetMsgParent(par);
if ((sx > 0) && (sy > 0)) {
  CreateXtWdg(nom, xmFormWidgetClass , parwdg->XtWdg(), sx, sy, px, py);
  int fbase = PIXMFORMFRACBASE ;  // Valeur de XmNfractionBase des XmForm ds PIContainerX
  Arg  wargs[5];
  int n=0;
  XtSetArg(wargs[n],XmNfractionBase, fbase);  n++;
  XtSetArg(wargs[n],XmNhorizontalSpacing, 0);  n++;
  XtSetArg(wargs[n],XmNverticalSpacing, 0);  n++;
  XtSetValues(XtWdg(), wargs, n);
  }
mTopWdg = parwdg;
}

/* --Methode-- */
PIContainerX::~PIContainerX()
{}


/* --Methode-- */
void PIContainerX::Process(PIMessage msg, PIMsgHandler* sender, void* data)
{
// Traitement specifique pour le top-container de PIApplicationX
if ((mTopWdg != NULL) && (ModMsg(msg) == PIMsg_ResizeRequest)) {
  // On change la taille de la fenetre - data est un pointeur sur entier
  // data[0] represente l'increment (positif ou negatif) en X, data[1] en Y
  int* nsz = (int*) data;
  mTopWdg->SetSize(mTopWdg->XSize()+nsz[0], mTopWdg->YSize()+nsz[1]);
  return;
  }  
else ReSend(msg, sender, data);
}

/* --Methode-- 
void PIContainerX::Show()
{
PIContainerGen::Show();
Manage();
}

void PIContainerX::Hide()
{
PIContainerGen::Hide();
UnManage();
}

*/
