#ifndef PIWDG_MAC_SEEN
#define PIWDG_MAC_SEEN

#include "piwdggen.h"
#include "pippviewadapter.h"
#include <LPane.h>
#include <LListener.h>

class PIWdgMac : public PIWdgGen, public LListener {
public:
  
                         PIWdgMac(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual                ~PIWdgMac();
  virtual void			 FinishCreate(); // apres avoir installe les sous-vues
                                       
  virtual void	         ListenToMessage(MessageT inMessage, void *ioParam);
  virtual void           SetLabel(string const&);

  virtual void           SetSize(int sx, int sy);
  virtual void           SetPos(int px, int py);
  virtual void           SetBorderWidth(int /*bw*/) {}
  
  virtual void           SetBinding(PIBindingKind left, PIBindingKind top, 
                                    PIBindingKind right, PIBindingKind bottom);
  virtual bool           GetBinding(PIBindingKind& left, PIBindingKind& top, 
                                    PIBindingKind& right, PIBindingKind& bottom);
  virtual int            XSize();
  virtual int            YSize();
  virtual int            XPos();
  virtual int            YPos();
  virtual string         Nom()  { return mNom; }

// Pour activer, desactiver un composant graphique (PIWdg)
  virtual void           Manage();
  virtual void           UnManage();
  virtual bool           IfManaged();
  virtual bool           IsVisible();
  
//  Fonction qui doit etre appelee pour rafraichir la fenetre 
  virtual void       	 Refresh();
  
//  Pour rendre un composant graphique (PIWdg) sensible/insensible 
//  aux actions utilisateur (souris, clavier, ...)
  virtual void           SetSensitive();
  virtual void           SetUnSensitive();
  virtual bool           IfSensitive();

//  Gestion de copier-coller
  virtual bool           ClaimSelection(unsigned int typ=PICP_string);
  virtual void           SelectionLost();
  virtual unsigned int   RequestSelection(unsigned int typ=PICP_string);
  virtual void*          ProvideSelection(unsigned int& typ, unsigned int& len);
  virtual void           PasteSelection(unsigned int typ, void *, unsigned int l);
  virtual void           CopyFromSelection(char *, int l);
  virtual char*          SelectionString(unsigned int& len);
  virtual void           SelectionTransferEnd();

//  Copie depuis un PIWdgGen
  virtual void		 CopyFrom(PIWdgGen* wdg, int ox, int oy, int dx, int dy, int x, int y);

//  Gestion des EventHandler
  virtual void		 AddDrawHandler(PIEventHandler* drwh, bool ad=false);
  virtual void		 RemoveDrawHandler(PIEventHandler* drwh);
  virtual void		 AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad=false);
  virtual void		 RemoveEventHandler(PIEventHandler* evh);


  LPane*                 GetPane() {return mPane;}
  
protected:
  LPane*				 mPane;
  PIPPViewAdapter*       mAdapter;
  SPaneInfo				 mAdapterPaneInfo;
  SViewInfo				 mAdapterViewInfo;
  SPaneInfo				 mPaneInfo;
  SViewInfo				 mViewInfo;
  string                 mNom;
  
  friend class PIGraphicMac;
};

typedef PIWdgMac PIWdg;

// -------- La classe PIScreenBuffer ----------

#include <UGWorld.h>

class PIScreenBuffer {
public :
                 PIScreenBuffer(int sx, int sy);
  virtual       ~PIScreenBuffer();

  virtual int       XSize();
  virtual int       YSize();
  virtual void      CopyFromWdg(PIWdg* wdg, int ox, int oy, int dx, int dy, int x, int y);
  virtual void      CopyToWdg(PIWdg* wdg, int ox, int oy, int dx, int dy, int x, int y);
  virtual void      CopyFrom(PIScreenBuffer* grb, int ox, int oy, int dx, int dy, int x, int y);

protected :
  LGWorld* mGWorld;
};



#endif
