#include <stdio.h>
#include <stdlib.h>
#include <typeinfo>
#include <iostream>
#include <string>

#include "ppersist.h"
#include "anydataobj.h"
#include "sambainit.h"

#ifdef __MWERKS__
#include <console.h>
#endif


/*!
  \defgroup PrgUtil PrgUtil module
  This module contains simple programs to perform various utility tasks:
  <UL>
  <LI> scanppf : Check and scan PPF files (scanppf.cc)
  <LI> scanfits : Check and scan FITS files (scanfits.cc)
  <LI> runcxx : Compile and run simple C++ code using SOPHYA (runcxx.cc)
  <LI> prjsmap : Molleweide and sinus projection of sky maps (prjsmap.cc)
  <LI> map2cl : Computes power spectra (C(l)) on spherical maps (map2cl.cc)
  <LI> cl2map : generates spherical maps from power spectra (C(l)) (cl2map.cc)
  </UL>
*/

/*!
  \ingroup PrgUtil
  \file scanppf.cc
  \brief \b scanppf: Check and scan PPF files

  \verbatim

  csh> scanppf -h
  SOPHYA Version  1.1 Revision 0 (V_Fev2001) -- Mar  9 2001 15:45:31 cxx
  Usage: scanppf filename [s/n/a0/a1/a2/a3]
     s[=default} : Sequential reading of objects
     n : Object reading at NameTags
     a0...a3 : Tag List with PInPersist.AnalyseTags(0...3)

  \endverbatim
*/

int main(int narg, char* arg[])
{

#ifdef __MWERKS__
narg = ccommand(&arg);
#endif

SambaInitiator smbinit;

if ((narg < 2) || (strcmp(arg[1],"-h") == 0) ) {
  cerr << " Usage: scanppf filename [s/n/a0/a1/a2/a3] \n" 
       << "   s[=default} : Sequential reading of objects \n" 
       << "   n : Object reading at NameTags \n"
       << "   a0...a3 : Tag List with PInPersist.AnalyseTags(0...3) \n" << endl;
  exit(0);
  }

try {
  string flnm = arg[1];
  bool seq=true;
  bool ana=false;
  int analev = 0;
  string opt = "s";
  if (narg > 2) opt = arg[2];
  
  if (opt == "n")  seq = false;
  else if (opt[0] == 'a') {  ana = true;  analev = opt[1]-'0'; }

  if (ana)   cout << " Analyse PInPersist( " << flnm << ")  Level=" << analev << endl;
  else { 
    if (!seq) cout << "PInPersist( " << flnm << ") Object Reading at NameTags " << endl;
    else  cout << "PInPersist( " << flnm << ") Sequential Object Reading " << endl;
  }
   
  PPersist* op = NULL;
  cout << " Opening PPF file " << flnm << endl; 
  PInPersist s(flnm);

  if (ana) s.AnalyseTags(analev);   // Analysing all tags in file 

  else {
    cout << " Version= " << s.Version() << " CreationDate= " << s.CreationDateStr() << endl;
    int nt = s.NbTags();
    cout << " Number of tags in file = " << nt << endl;
    if ( seq || (nt < 1) ) {
      while (1) {
	op = s.ReadObject();
	cout << " Object Type " << typeid(*op).name() << endl;
	if (op) delete op;
      }
    }
    for(int i=0; i<nt; i++) {
      cout << ">>> TagNum= " << i << " TagName= " << s.GetTagName(i) << endl;
      s.GotoTagNum(i);
      op = s.ReadObject();
      cout << " Object Type " << typeid(*op).name() << endl;
      if (op) delete op;
    }
  }
}
catch (PThrowable & pex) {
  cerr << " scanppf/Error - Exception catched " << (string)typeid(pex).name()
       << " - Msg= " << pex.Msg() << endl;
}

cout << " ----------- End of scanppf ------------- " << endl;
}
