#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>
#include <fstream>
#include "sophyainit.h"
#include "timing.h"
#include "commander.h"


class TCmdExecutor : public CmdExecutor {
public:
  TCmdExecutor(Commander& cmd);
  virtual ~TCmdExecutor() { }

  virtual int Execute(string& keyw,vector<string>& args, string& toks);
};

TCmdExecutor::TCmdExecutor(Commander& cmd)
{ 
string hgrp = "TCmdExecutor";
string usage,kw;

kw = "ls";
usage = "ls: Execute /usr/bin/ls \n";
cmd.RegisterCommand(kw, usage, this, hgrp);
kw = "mv";
usage = "mv: Execute /usr/bin/mv \n";
cmd.RegisterCommand(kw, usage, this, hgrp);
kw = "cp";
usage = "cp: Execute /usr/bin/mv \n";
cmd.RegisterCommand(kw, usage, this, hgrp);
}

int TCmdExecutor::Execute(string& kw, vector<string>& args, string& toks)
{
  if ((kw!="ls")&&(kw!="mv")&&(kw!="cp"))  return 99; 
  string cmd;
  if (kw == "ls")     cmd = "/usr/bin/ls " ; 
  else if (kw == "mv") cmd = "/usr/bin/mv " ;
  else if (kw == "cp") cmd = "/usr/bin/cp " ;
  else cmd = "/usr/bin/echo " ;
  cout << "TCmdExecutor::Execute() : Executing " << cmd << endl;
  return system(cmd.c_str());
}

int  InputLoop(Commander & cmd);

/* --Main-- */
int main(int narg, char *arg[])
{

  SophyaInit();
  InitTim();

  try {
    Commander cmd;
    TCmdExecutor cmdex(cmd);
    InputLoop(cmd);
  } 
 
  catch (PThrowable & exc) {
    cerr << " Catched Exception " << (string)typeid(exc).name()
         << " - Msg= " << exc.Msg() << endl;
  }
  catch (...) {
    cerr << " some other exception was caught ! " << endl;
  }

  PrtTim(" End of tcmd ");
  return(0);
}

/* --Fonction-- */
int  InputLoop(Commander & cmd)
{
  cout << " tcmd/InputLoop() : Type in your commands, \n" 
       << "     end with a blanck line OR <Cntl>D " << endl;
  int line = 0;
  bool fg = true;
  char buff[1024];
  char * ret;
  while (fg) {
    printf("%d-%s ", line+1, cmd.GetCurrentPrompt().c_str());
    fflush(stdout);
    buff[0] = '\0';
    ret = fgets(buff, 1024, stdin);
    buff[1023] = '\0';
    if (ret && ( (buff[0] != '\0') && (buff[0] != '\n') && (buff[0] != '\r')) ) { 
      //      buff[strlen(buff)-1] = '\0';
      string cline = buff;
      cmd.Interpret(cline);
      line++;
    }
    else fg = false;
  }
  cout << " \n Total " << line << " lines from stdin -> Commander " << endl;
  if (line > 0) return(0);
  else return(1);
}


