// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: fitstoirdr.h,v 1.15 2003-10-13 20:48:37 aubourg Exp $


#ifndef FITSTOIRDR_H
#define FITSTOIRDR_H

#include "config.h"
#include "toiprocessor.h"
#include <string>
#include <vector>
#include <map>
#include "fitsio.h"
#include "flagtoidef.h"

class FITSTOIReader : public TOIProcessor {
public:
  FITSTOIReader(string fn,int buff_sz=1024);
  ~FITSTOIReader();

  void         setImplicitSN(long snStart=0);

  void         setBufferSize(int buffsz=1024);
  inline int   getBufferSize() { return Buff_Sz; }

  virtual void addFile(string fn);

  // Methode rajoutee pour gerer les fichiers de flag de LevelS 
  // Reza 18/6/2002 
  // fn : Nom du fichier FITS, 
  // flags: Indique le nombre de colonne et la correspondence avec les
  // flags d'ArchTOIPipe flags[0..N-1] ---> 1ere...Neme colonnes
  virtual void setFlagFile(string fn, vector<FlagToiDef> flags); 

  virtual void init();  
  virtual void run(); 
 
  inline int_8	ProcessedSampleCount() const { return totnscount; }
  virtual void printLimits();

protected:
  virtual long calcMinOut();
  virtual long calcMaxOut();
  
  // ajout vf 31/07/2002
  virtual bool checkSampleLimits(long& min, long& max, int pass);
  virtual void calcSampleLimits(long& min, long& max);
  virtual bool checkSampleLimits(int pass) {return TOIProcessor::checkSampleLimits(pass);}

  virtual void run1();
  virtual void run2();
  virtual void openFile(string fn);

private:
  fitsfile* fptr;
  int       fstatus;
  string    fname;   // current file
  long      nrows;   // current file
  int       firstSn; // current file
  int       Buff_Sz; // buffer size

  int       ncols;   // including flags. getNOut() is # of tois.
  
  // supression de la redefinition vf 23/08/2002
  //int       snBegin; // first file
  //int       snEnd;   // last file

  bool      implicitSN;
  long      implicitSNStart;
  
  vector<string> allfn;
  map<int,pair<int, bool> > colsinput; // iTOI -> (colonne, hasflag)
  // le flag est alors en colonne+1

  int_8 totnscount;   // Nombre total d'echantillon processe

  // Variables rajoutee pour gerer les fichiers de flag de LevelS (Reza 18/6/2002)
  bool sepFlagfile;
  string sepFlagFileName;
  vector<FlagToiDef> sepFlagCols;
  fitsfile* fptrflg;

};

#endif
