// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toiprocessor.h,v 1.21 2003-10-13 20:48:37 aubourg Exp $



#ifndef TOIPROCESSOR_H
#define TOIPROCESSOR_H

#include "config.h"

#include <pthread.h>

#include <string>
#include <map>
#include <iostream.h>

#ifndef NO_SOPHYA
#include "tarray.h"
using namespace SOPHYA;
#endif

#include "toi.h"


class TOIProcessor {
public:
  virtual void init();  
  // Les methodes qui suivent peuvent etre appelees par init
protected:
  int declareInput(string toi);
  int declareOutput(string toi);  
  
  // void declareMultInput(string toi);
  // Question : multiple output ? 

  void chkinit() {
   if (!inited) {init(); afterinit(); inited=true;}
  }
  bool inited;
  virtual void afterinit();

public:
  virtual void run();

  virtual long  getMinOut();
  virtual long  getMaxOut();
  
  // rajout vf 29/07/2002
  virtual void setRequestedSample(long begin, long end); 
  virtual bool getRequested();
  virtual bool checkSampleLimits(int pass);
  virtual void printLimits();

// rajout vf 29/07/2002
protected:
  bool requestedSample;
  long snBegin;
  long snEnd;
  long snMin;
  long snMax;
  virtual bool checkSampleLimits(long &min, long &max, int pass);


  // Les methodes qui suivent peut etre appelees par run
protected:
#ifndef NO_SOPHYA
  /* ---- l'interface va etre modifiee, NE PAS UTILISER
  Array         getData(int toiIndex, long iStart, long iEnd);
  Array         getError(int toiIndex, long iStart, long iEnd);
  TArray<int_4> getFlag(int toiIndex, long iStart, long iEnd);
          l'interface va etre modifiee, NE PAS UTILISER ---- */
#endif
  // si multiple input (indexed input), tableau 2D.

  // Les methodes qui suivent ne peuvent etre 
  // utilisees que sur des entrees simples
  double        getData(int toiIndex, long i);
  void          getData(int toiIndex, long i, double &data, uint_8 &flag);

  void          getData(int toiIndex, long i, long n, double* d);
  void          getData(int toiIndex, long i, long n, double* d, uint_8* f);
  
  //RZCMV  double        getError(int toiIndex, long i);
  //RZCMV  int_4         getFlag(int toiIndex, long i);

  void          wontNeedBefore(long i);
  long           wontNeedValue;
  void          setNeededHistory(long nsamples); // -1 : disable

  void          putData(int toiIndex, long i, double value, uint_8 flag=0);
  //RZCMV  void          putDataError(int toiIndex, long i, double value, 
  //RZCMV		             double error, int_4 flag=0);

  void          putData(int toiIndex, long i, long n, double const* val,
			uint_8 const* flg=0);

  // Gestion des bornes pour les transformations de TOIs...
public:  
  // Methodes passees en public par Reza, 14/5/2002
  virtual long   calcMinOut(); // Protected ?
  virtual long   calcMaxOut(); // Protected ?

  virtual long   getMinIn();
  virtual long   getMaxIn();
protected:
  // Implementation par defaut
  long           minOut;    // Cache for calcMinOut() value. Protected ?
  long           maxOut;    // Cache for calcMaxOut() value. Protected ?

  int           upExtra;  // MaxIn - MaxOut : extra samples for processing
  int           lowExtra; // MinOut - MinIn : extra samples for processing

  long           forcedMinIn; // to process a subset of data
  long           forcedMaxIn; // to process a subset of data
  void          setSampleSubset(long min, long max);

  int           neededHistory;

protected:
  int           getInputTOIIndex(string toi);
  int           getOutputTOIIndex(string toi);

  //  Methodes rajoutees par Reza 11/3/2001
  TOI*          getInputTOI(int toiIndex);
  TOI*          getOutputTOI(int toiIndex);
  bool          checkInputTOIIndex(int toiIndex);
  bool          checkOutputTOIIndex(int toiIndex);

  //  Fin rajout Reza 11/3/2001 

  void          autoWontNeed(long iCur);
  long           lastAWN;


public:
  // Appele par les assembleurs de pipeline
  virtual void  addInput(string name, TOI* toi);
  virtual void  addOutput(string name, TOI* toi);


  int getNIn()  {chkinit(); return inIx.size();}
  int getNOut() {chkinit(); return outIx.size();}
  string getOutName(int i);
  string getInName(int i);

  //  Methodes rajoutees par Reza 11/3/2001
  virtual void  PrintStatus(::ostream & os) ; // const plus tard
  //  Fin rajout Reza 11/3/2001 

  virtual void  start();
  
  TOIProcessor();
  virtual ~TOIProcessor();
  
  void setMinSn(long n) {forcedMinIn = n;}
  void setMaxSn(long n) {forcedMaxIn = n;}

  // ajout vf 23/08/2002
  TOI* getOutToi(string sortie);

  virtual void setName(string n) {name=n;}

protected:

  map<string, int> inIx;
  map<string, int> outIx;
  TOI**  inTOIs;
  TOI**  outTOIs;

  string name;
  // Thread handling
  pthread_t        thread;
  pthread_cond_t   dataReady;
  pthread_mutex_t  mutex;
  pthread_mutexattr_t mutattr;

  void lock() {
    pthread_mutex_lock(&mutex);
  }

  void unlock() {
    pthread_mutex_unlock(&mutex);
  }
  
  void wait()   {
    pthread_cond_wait(&dataReady, &mutex); 
  }

  void notify();
  

  friend class TOI;
  
  static void* ThreadStart(void *);
  void warnPutDone();
};

inline ::ostream & operator << (::ostream & os, TOIProcessor /*const*/ & toip)
{ toip.PrintStatus(os); return os; }


#endif








