// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Cecile Renault
//                               Christophe Magneville
//                               Reza Ansari
// $Id: fitsringrdr.h,v 1.4 2003-10-13 20:48:36 aubourg Exp $

#ifndef FITSRINGRDR_H
#define FITSRINGRDR_H

#include "config.h"
#include "toiprocessor.h"
#include <string>
#include <vector>
#include <map>
#include "fitsio.h"
#include "flagtoidef.h"

class FITSRingReader : public TOIProcessor {
public:
  FITSRingReader(string fn,int buff_sz=1024);
  ~FITSRingReader();


  void         setBufferSize(int buffsz=1024);
  inline int   getBufferSize() { return Buff_Sz; }
  
  void  init();
  void  run();

  inline int_8	ProcessedSampleCount() const { return totnscount; }
  virtual void printLimits();

protected:
  virtual long  calcMinOut();
  virtual long  calcMaxOut();
  
  // ajout vf 31/07/2002
  virtual bool checkSampleLimits(long& min, long& max, int pass);
  virtual void calcSampleLimits(long& min, long& max);
  virtual bool checkSampleLimits(int pass) {return TOIProcessor::checkSampleLimits(pass);}

  virtual void openFile(string fn);

private:
  long nSamples;
  long nRings;
  double aperture;
  string fname;
  fitsfile *fptr;
  int fstatus;
  int Buff_Sz; // buffer size = nSamples
  vector<string> allfn;
  int_8 totnscount;   // Nombre total d'echantillon processe
};


#endif
