#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <complex>
#include "pexceptions.h"
#include "ndatablock.h"

#define DEBUG_NDATABLOCK

#ifdef DEBUG_NDATABLOCK
  static size_t NallocData = 0;
  static size_t NallocSRef = 0;
#endif

// LOGIQUE DE BASE:
//   - le createur par copie et la surcharge de l operateur = "partage" les donnees
//   - gestion du partage de reference

//************ Createur, Destructeur, gestion des donnees

template <class T>
NDataBlock<T>::NDataBlock(size_t n)
// Createur d'une structure de "n" donnees
: mSz(0), mSRef(NULL), mIsTemp(false)
{
Alloc(n);
}

template <class T>
NDataBlock<T>::NDataBlock(size_t n, T* data, Bridge* br)
// Createur d'une structure de "n" donnees, avec donnees preallouees
: mSz(0), mSRef(NULL), mIsTemp(false)
{
Alloc(n,data,br);
}

template <class T>
NDataBlock<T>::NDataBlock()
// Createur par default
: mSz(0), mSRef(NULL), mIsTemp(false)
{
}

template <class T>
NDataBlock<T>::NDataBlock(NDataBlock<T>& a)
// Createur par copie
// ATTENTION: partage les donnees avec "a"
// Ecriture: NDataBlock a = b;
//           NDataBlock a(b)
: mSz(0), mSRef(NULL), mIsTemp(false)
{
Share(a);
}

template <class T>
NDataBlock<T>::NDataBlock(NDataBlock<T>& a,bool share)
// Createur avec choix de partager ou non
: mSz(0), mSRef(NULL), mIsTemp(false)
{
if(share) Share(a); else Clone(a);
}

template <class T>
NDataBlock<T>::~NDataBlock()
// Destructeur
{
Delete();
}

template <class T>
void NDataBlock<T>::Alloc(size_t n,T* data,Bridge* br)
// Allocation d'un NOUVEL espace de stoquage
// Si data==NULL : allocation de l'espace memoire
//    data!=NULL : partage des donnees avec l'adresse data
// Si br==NULL   : les donnees nous appartiennent
//    br!=NULL   : les donnees ne nous appartiennent pas (ex Blitz)
{
#ifdef DEBUG_NDATABLOCK
cout<<"NDataBlock::Alloc("<<n<<") mSRef="<<mSRef<<endl;
#endif
if(n==0) throw(SzMismatchError("NDataBlock::Alloc n==0\n"));
if(mSRef) Delete();
mSz = n;
mSRef = new NDREF;
mSRef->nref = 1;
if(data) mSRef->data = data; else mSRef->data = new T[n];
mSRef->bridge = br;
#ifdef DEBUG_NDATABLOCK
if(!data) NallocData++; NallocSRef++;
cout<<"NDataBlock::Alloc("<<n<<") mSRef="<<mSRef
    <<" mSRef->nref"<<mSRef->nref<<" mSRef->data"<< mSRef->data
    <<" Total("<<NallocData<<","<<NallocSRef<<")"<<endl;
#endif
}

template <class T>
void NDataBlock<T>::Clone(NDataBlock<T>& a)
// Clone (copie de donnee) a partir de "a"
{
#ifdef DEBUG_NDATABLOCK
cout<<"NDataBlock::Clone("<<&a<<endl;
#endif
if(!a.mSRef) {mSz=0; mSRef=NULL;} // cas ou "a" est cree par defaut
else if(a.IsTemp()) Share(a);
else {Alloc(a.mSz); memcpy(Dtata(),a.Dtata(),mSz*sizeof(T));}
}

template <class T>
void NDataBlock<T>::Share(NDataBlock<T>& a)
// Partage des donnees avec "a"
{
#ifdef DEBUG_NDATABLOCK
cout<<"NDataBlock::Share("<<&a<<") a.mSRef="<<a.mSRef<<" mSRef="<<mSRef<<endl;
#endif
if(&a==NULL) throw(NullPtrError("NDataBlock::Share  &a==NULL\n"));
// on ne peut partager si "a" pas alloue
if(!a.mSRef) throw(NullPtrError("NDataBlock::Share not allocated a\n"));
if(mSRef) Delete();
mSz = a.mSz; mSRef = a.mSRef; mSRef->nref++;
#ifdef DEBUG_NDATABLOCK
cout<<"...NDataBlock::Share("<<&a<<") mSRef="<<mSRef
    <<" mSRef->nref"<<mSRef->nref<<" mSRef->data"<< mSRef->data<<endl;
#endif
}

template <class T>
void NDataBlock<T>::Delete(void)
// Pour detruire les pointeurs en tenant compte des references
{
#ifdef DEBUG_NDATABLOCK
cout<<"NDataBlock::Delete() mSRef="<<mSRef;
if(mSRef) cout<<" mSRef->nref"<<mSRef->nref<<" mSRef->data"<<mSRef->data;
cour<<endl;
#endif
if(mSRef==NULL) return; // cas du createur par defaut
mSRef->nref--;
if(mSRef->nref != 0) {
#ifdef DEBUG_NDATABLOCK
  cout<<"...NDataBlock::Delete() pas de desallocation il reste nref="<<mSRef->nref<<endl;
#endif
  return;
}
#ifdef DEBUG_NDATABLOCK
if(!mSRef->bridge) NallocData--; NallocSRef--;
cout<<"...NNDataBlock::Delete() desallocation complete il reste nref="<<mSRef->nref
    <<" Total("<<NallocData<<","<<NallocSRef<<")"<<endl;
#endif
// Si il y a un Bridge les donnees ne n'appartiennent pas, on detruit le Bridge
if(mSRef->bridge) delete mSRef->bridge; 
// sinon, les donnees ont ete allouees par nos soins, on libere l'espace memoire
else delete [] mSRef->data; 
mSRef->bridge=NULL; mSRef->data=NULL;
delete mSRef; mSRef=NULL;
}

template <class T>
void NDataBlock<T>::ReSize(size_t n)
// Re-dimension, dans ce cas re-allocation de la place
{
Alloc(n);
}

//**** Impression

template <class T>
void NDataBlock<T>::Print(size_t i1,size_t n)
// Impression de n elements a partir de i1
{
size_t nr = 0;
T* p = NULL;
if(mSRef) {nr = mSRef->nref; p = mSRef->data;}
cout<<"NDataBlock::Print nel=%ld nref=%d (%p)\n",mSz,nr,p;
if(i1<0 || i1>=mSz || n<=0 || !p) return;
size_t i2 = i1+n; if(i2>mSz) i2=mSz;
size_t im = 1;
while(i1<i2) {
  cout<<" "<<(*this)(i1);  i1++;
  if(im==10) {cout<<"\n"; im=1;} else im++;
}
}

//**** Surcharge de = : NDataBlock=NDataBlock; NDataBlock=<T> b; 

template <class T>
NDataBlock<T>& NDataBlock<T>::operator = (const NDataBlock<T>& a)
// surcharge avec partage des donnees
// Ecriture:  NDataBlock a; a = b;
//            NDataBlock a(10); a = b; (a est re-affecte)
{
if(this == &a) return *this;
if(a.mSz!=mSz) throw(SzMismatchError("NDataBlock::operator=A size mismatch/null\n"));
Share(a);
return *this;
}

template <class T>
NDataBlock<T>& NDataBlock<T>::operator = (const T v)
// surcharge avec copie des donnees (pas de partage)
// "this" est sur-ecrit, attention au partage de reference!
// NDataBlock a; a = v; ou bien NDataBlock a(10); a = v;
{
if(mSz==0) throw(SzMismatchError("NDataBlock::operator=v null size\n"));
T* p=Begin(), pe=End();
while (p<pe) *p++ = v;
return *this;
}

//**** Surcharge de +=,-=,*=,/= (INPLACE): NDataBlock += <T> b;

template <class T>
NDataBlock<T>& NDataBlock<T>::operator += (T b)
{
if(mSz==0) throw(SzMismatchError("NDataBlock::operator+=v null size\n"));
T* p=Begin(), pe=End();
while (p<pe) *p++ += b;
return *this;
}

template <class T>
NDataBlock<T>& NDataBlock<T>::operator -= (T b)
{
if(mSz==0) throw(SzMismatchError("NDataBlock::operator-=v null size\n"));
T* p=Begin(), pe=End();
while (p<pe) *p++ -= b;
return *this;
}

template <class T>
NDataBlock<T>& NDataBlock<T>::operator *= (T b)
{
if(mSz==0) throw(SzMismatchError("NDataBlock::operator*=v null size\n"));
T* p=Begin(), pe=End();
while (p<pe) *p++ *= b;
return *this;
}

template <class T>
NDataBlock<T>& NDataBlock<T>::operator /= (T b)
{
if(b==(<T>) 0) throw(ParmError("NDataBlock::operator/=v divide by zero\n"));
if(mSz==0) throw(SzMismatchError("NDataBlock::operator/=v null size\n"));
T* p=Begin(), pe=End();
while (p<pe) *p++ /= b;
return *this;
}

//**** Surcharge de +=,-=,*=,/= (INPLACE): NDataBlock += NDataBlock;

template <class T>
NDataBlock<T>& NDataBlock<T>::operator += (const NDataBlock<T>& a)
{
if(mSz==0 || mSz!=a.mSz) throw(SzMismatchError("NDataBlock::operator+=A size mismatch/null"));
T* p=Begin(), pe=End(), pa=a.Begin();
while (p<pe) *p++ += *pa++; // ca marche meme si *this=a
return *this;
}

template <class T>
NDataBlock<T>& NDataBlock<T>::operator -= (const NDataBlock<T>& a)
{
if(mSz==0 || mSz!=a.mSz) throw(SzMismatchError("NDataBlock::operator-=A size mismatch/null"));
T* p=Begin(), pe=End(), pa=a.Begin();
while (p<pe) *p++ -= *pa++; // ca marche meme si *this=a
return *this;
}

template <class T>
NDataBlock<T>& NDataBlock<T>::operator *= (const NDataBlock<T>& a)
{
if(mSz==0 || mSz!=a.mSz) throw(SzMismatchError("NDataBlock::operator*=A size mismatch/null"));
T* p=Begin(), pe=End(), pa=a.Begin();
while (p<pe) *p++ *= *pa++; // ca marche meme si *this=a
return *this;
}

template <class T>
NDataBlock<T>& NDataBlock<T>::operator /= (const NDataBlock<T>& a)
{
if(mSz==0 || mSz!=a.mSz) throw(SzMismatchError("NDataBlock::operator/=A size mismatch/null"));
T* p=Begin(), pe=End(), pa=a.Begin();
while (p<pe) *p++ /= *pa++;
return *this;
}

//**** FIN DES METHODES DE LA CLASSE

//**** Surcharge de +,-,*,/ : NDataBlock = NDataBlock+<T>b; NDataBlock = <T>b+NDataBlock;
// ATTENTION: re-affectation imposee

template <class T>
NDataBlock<T> operator + (const NDataBlock<T>& a, T b)
{
NDataBlock<T> result(a,false); result.SetTemp(true);
return (result += b);
}

template <class T>
NDataBlock<T> operator + (T b, const NDataBlock<T>& a)
{
NDataBlock<T> result(a,false); result.SetTemp(true);
return (result += b);
}

template <class T>
NDataBlock<T> operator - (const NDataBlock<T>& a, T b)
{
NDataBlock<T> result(a,false); result.SetTemp(true);
return (result -= b);
}

template <class T>
NDataBlock<T> operator - (T b, const NDataBlock<T>& a)
{
NDataBlock<T> result(a,false); result.SetTemp(true);
T* p=result.Begin(), pe=result.End(), pa=a.Begin();
while(p<pe) {*p++ = b - *pa++;}
return result;
}

template <class T>
NDataBlock<T> operator * (const NDataBlock<T>& a, T b)
{
NDataBlock<T> result(a,false); result.SetTemp(true);
return (result *= b);
}

template <class T>
NDataBlock<T> operator * (T b, const NDataBlock<T>& a)
{
NDataBlock<T> result(a,false); result.SetTemp(true);
return (result *= b);
}

template <class T>
NDataBlock<T> operator / (const NDataBlock<T>& a, T b)
{
NDataBlock<T> result(a,false); result.SetTemp(true);
return (result /= b);
}

template <class T>
NDataBlock<T> operator / (T b, const NDataBlock<T>& a)
{
NDataBlock<T> result(a,false); result.SetTemp(true);
T* p=result.Begin(), pe=result.End(), pa=a.Begin();
while(p<pe) {*p++ = b / *pa++;}
return result;
}

//**** Surcharge de +,-,*,/ : NDataBlock = NDataBlock+NDataBlock;

template <class T>
NDataBlock<T> operator + (const NDataBlock<T>& a, const NDataBlock<T>& b)
{
if(a.mSz!=b.mSz) throw(SzMismatchError("NDataBlock operator C=A+B size mismatch/null\n"));
if(b.IsTemp()) {
  NDataBlock<T> result(b,true); result.SetTemp(true);
  return result += a;
} else {
  NDataBlock<T> result(a,false); result.SetTemp(true);
  return result += b;
}
}

template <class T>
NDataBlock<T> operator * (const NDataBlock<T>& a, const NDataBlock<T>& b)
{
if(a.mSz!=b.mSz) throw(SzMismatchError("NDataBlock operator C=A*B size mismatch/null\n"));
if(b.IsTemp()) {
  NDataBlock<T> result(b,true); result.SetTemp(true);
  return result *= a;
} else {
  NDataBlock<T> result(a,false); result.SetTemp(true);
  return result *= b;
}
}

template <class T>
NDataBlock<T> operator - (const NDataBlock<T>& a, const NDataBlock<T>& b)
{
if(a.mSz!=b.mSz) throw(SzMismatchError("NDataBlock operator C=A-B size mismatch/null\n"));
if(b.IsTemp()) {
  NDataBlock<T> result(b,true); result.SetTemp(true);
  T* p=result.Begin(), pe=result.End(), pa=a.Begin();
  while(p<pe) {*p = *pa++  - *p; p++;}
  return result;
} else {
  NDataBlock<T> result(a,false); result.SetTemp(true);
  return result -= b;
}
}

template <class T>
NDataBlock<T> operator / (const NDataBlock<T>& a, const NDataBlock<T>& b)
{
if(a.mSz!=b.mSz) throw(SzMismatchError("NDataBlock operator C=A/B size mismatch/null\n"));
if(b.IsTemp()) {
  NDataBlock<T> result(b,true); result.SetTemp(true);
  T* p=result.Begin(), pe=result.End(), pa=a.Begin();
  while(p<pe) {*p = *pa++  / *p; p++;}
  return result;
} else {
  NDataBlock<T> result(a,false); result.SetTemp(true);
  return result /= b;
}
}




#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template NDataBlock<uint_1>
#pragma define_template NDataBlock<uint_2>
#pragma define_template NDataBlock<int_2>
#pragma define_template NDataBlock<int_4>
#pragma define_template NDataBlock<int_8>
#pragma define_template NDataBlock<uint_2>
#pragma define_template NDataBlock<uint_4>
#pragma define_template NDataBlock<uint_8>
#pragma define_template NDataBlock<r_4>
#pragma define_template NDataBlock<r_8>
#pragma define_template NDataBlock<complex<float>>
#pragma define_template NDataBlock<complex<double>>
#endif

#ifdef __GNU_TEMPLATES__
template class NDataBlock<uint_1>;
template class NDataBlock<uint_2>;
template class NDataBlock<int_2>;
template class NDataBlock<int_4>;
template class NDataBlock<int_8>;
template class NDataBlock<uint_2>;
template class NDataBlock<uint_4>;
template class NDataBlock<uint_8>;
template class NDataBlock<r_4>;
template class NDataBlock<r_8>;
template class NDataBlock<complex<float>>;
template class NDataBlock<complex<double>>;
#endif

#if defined(__ANSI_TEMPLATES__) 
template class NDataBlock<uint_1>;
template class NDataBlock<uint_2>;
template class NDataBlock<int_2>;
template class NDataBlock<int_4>;
template class NDataBlock<int_8>;
template class NDataBlock<uint_2>;
template class NDataBlock<uint_4>;
template class NDataBlock<uint_8>;
template class NDataBlock<r_4>;
template class NDataBlock<r_8>;
template class NDataBlock<complex<float>>;
template class NDataBlock<complex<double>>;
#endif

#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template template<class uint_1> NDataBlock<uint_1> operator + (const NDataBlock<uint_1>& a, uint_1 b);
#endif

#ifdef __GNU_TEMPLATES__
#endif

#if defined(__ANSI_TEMPLATES__) 
#endif
