/* Interface Fits BINARY/ASCII Table Column Reader    cmv 26/09/2001 */
#ifndef FABTCOLREAD_H_SEEN
#define FABTCOLREAD_H_SEEN

#include "machdefs.h"
#include <iostream>
#include <string.h>
#include <string>

#include "anydataobj.h"
#include "tvector.h"
#include "FitsIO/fitsio.h"

namespace SOPHYA {

///////////////////////////////////////////////////////////////////
//! Class for opening a FITS file for reading
class FitsOpenFile : public AnyDataObj {
public:
  FitsOpenFile(string fname);
  FitsOpenFile(const char *cfname);
  FitsOpenFile();
  FitsOpenFile(FitsOpenFile& fof);
  virtual ~FitsOpenFile();

  inline string GetFileName() {return FitsFN;}
  inline int GetNHdu() {return NHdu;}
  inline fitsfile* GetFitsPtr() {return FitsPtr;}

protected:
  void Init(const char *cfname);
  void Delete(void);
  void printerror(int sta) const;

  string FitsFN;
  int NHdu;
  fitsfile *FitsPtr;
};

///////////////////////////////////////////////////////////////////
//! Class for reading a column in a FITS ASCII or BINARY table
class FitsABTColRd : public AnyDataObj {
public:
  FitsABTColRd(FitsOpenFile* fof,string collabel,int ihdu=0
              ,long blen=100,long bsens=1,int lp=0);
  FitsABTColRd(FitsOpenFile* fof,int colnum,int ihdu=0
              ,long blen=100,long bsens=1,int lp=0);
  FitsABTColRd(FitsABTColRd& fbt);
  FitsABTColRd();
  virtual ~FitsABTColRd();

  void ChangeBuffer(long blen=100,long bsens=1);

  double ReadKey(char *keyname);
  long   ReadKeyL(char *keyname);
  string ReadKeyS(char *keyname);

  double Read(long n,bool usebuffer=true);

  long   Read(long n1,long n2,TVector<uint_2>& data);
  long   Read(long n1,long n2,TVector<int_4>& data);
  long   Read(long n1,long n2,TVector<int_8>& data);
  long   Read(long n1,long n2,TVector<float>& data);
  long   Read(long n1,long n2,TVector<double>& data);

  //! return the value of the first row
  double ReadFirstRow(bool usebuffer=false)
                     {return Read(0,usebuffer);}
  //! return the value of the last row
  double ReadLastRow(bool usebuffer=false)
                    {return Read(NBline-1,usebuffer);}

  long FirstRow(double val1,double val2,long rowstart=-1);
  long LastRow(double val1,double val2,long rowstart=-1);

  //! Set debug level
  inline void    SetDebug(int lp=0) {DbgLevel = (unsigned short) lp;}
  //! Set null value to be return when reading null data (0=return the data)
  inline void    SetNulVal(double nulval=0.) {NulVal = nulval;}
  //! Get the FITS file name
  inline string  GetFileName(void) {return FitsFN;}
  //! Get the pointer to FitsOpenFile
  inline FitsOpenFile* GetFitsOpenFile(void) {return FitsOF;}
  //! Get the FITS file pointer (cfistio pointer)
  inline fitsfile* GetFitsPointer(void) {return FitsPtr;}
  //! Get the number of HDU in the FITS file
  inline int     GetNHDU(void) {return NHdu;}
  //! Get the number of the HDU read
  inline int     GetHDU(void) {return IHdu;}
  //! Get the HDU type
  inline int     GetHDUType(void) {return HduType;}
  //! Get the number of rows in the FITS HDU to be read
  inline long    GetNbLine(void) {return NBline;}
  //! Get the number of columns in the FITS HDU to be read
  inline int     GetNbCol(void) {return NBcol;}
  //! Get the columns number that is read
  inline int     GetColNum(void) {return ColNum;}
  //! Get the columns label that is read
  inline string  GetColLabel(void) {return ColLabel;}
  //! Get the columns type code that is read
  inline int     GetColTypeCode(void) {return ColTypeCode;}
  //! Get the columns fits tunit that is read
  inline string  GetColTUnit(void) {return ColTUnit;}
  //! Get the columns fits tform that is read
  inline string  GetColTForm(void) {return ColTForm;}
  //! Get the read requested buffer length
  inline long    GetBLen(void) {return BuffLen;}
  //! Get the read buffer direction
  inline long    GetBSens(void) {return BuffSens;}
  //! Print to os
  virtual void   Print(ostream& os,int lp=1) const;
  //! Print to stdout
  inline  void   Print(int lp=1) const {Print(cout,lp);}
  //! Get the read effective buffer length
  inline long    GetNBuffer(void) {return NBuffer;}
  //! Get the read bufferpointer
  inline double* GetBuffer(void) {return Buffer;}

protected:
  void Init(FitsOpenFile* fof,const char *collabel,int colnum
           ,int ihdu,long blen,long bsens,int lp);
  void Delete(void);
  void printerror(int sta) const;

  string FitsFN,ColLabel,ColTUnit,ColTForm;
  int ColNum,ColTypeCode,IHdu,NHdu,HduType,NBcol;
  long NBline;

  double NulVal;
  unsigned short DbgLevel;
  long BuffLen, BuffSens;

  unsigned long NFitsRead;
  FitsOpenFile* FitsOF;
  fitsfile* FitsPtr;
  long LineDeb, LineFin;
  double *Buffer;
  long NBuffer;
};

///////////////////////////////////////////////////////////////////
//! Class for reading a column in a FITS ASCII or BINARY table with fits file opening
class FitsABTColRead : public FitsABTColRd {
public:
  FitsABTColRead(string fname,string collabel,int ihdu=0
                ,long blen=100,long bsens=1,int lp=0);
  FitsABTColRead(string fname,int colnum,int ihdu=0
                ,long blen=100,long bsens=1,int lp=0);
  FitsABTColRead(const char *cfname,const char *collabel,int ihdu=0
                ,long blen=100,long bsens=1,int lp=0);
  FitsABTColRead(const char *cfname,int colnum,int ihdu=0
                ,long blen=100,long bsens=1,int lp=0);
  FitsABTColRead(FitsABTColRead& fbt);
  FitsABTColRead();
  virtual ~FitsABTColRead();
};

} // namespace SOPHYA
#endif    /* FABTCOLREAD_H_SEEN */
