// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toiseqbuff.h,v 1.11 2003-11-14 12:34:56 aubourg Exp $

#ifndef TOISEQBUFF_H
#define TOISEQBUFF_H

#include "toi.h"

// -------------------  TOISeqBuffered ---------------------------
// Classe de TOI avec buffer, et echantillonnage regulier.
// Pour le moment au moins,
// il faut que les providers fassent arriver les donnees par samplenum croissant.
// ---------------------------------------------------------------

class TOISeqBuffered : public TOIRegular {
public:
  TOISeqBuffered(int wsz=8192);
  TOISeqBuffered(string nm, int wsz=8192);
  virtual ~TOISeqBuffered();

  
  inline  void SetBufferSize(int wsz)  // ATTENTION - Ne doit pas etre appele
               { AllocBuffer(wsz); }   // apres le demarrage des threads

  virtual void PrintStatus(::ostream & os) const; 

  inline void setDebugLevel(int lev=0) { dbglev=lev; }
  inline int  getDebugLevel() const { return dbglev; }

  virtual double        getData(long i);
  virtual void          getData(long i, double& data,  uint_8& flag);
  virtual void          getData(long i, int n, double* data, uint_8* flg=0);
  virtual void          putData(long i, double  value, uint_8  flag=0);
  virtual void          putData(long i, int n, double const* val, uint_8 const* flg=0);
  virtual void          wontNeedBefore(long i);

  inline long getFirstIn() const { return first_in; }
  inline long getFirstOut() const { return first_out; }
  inline long getLastIn() const { return (next_in-1); }
  inline long getLastOut() const { return (next_out-1); }


  virtual DataStatus isDataAvailNL(long iStart, long iEnd);
  virtual DataStatus isDataAvailNL(long i); // override required

protected:
  double* data;
  uint_8*  flags;
  int wsize;
  int buffsize;
  long next_in;
  long next_out;
  long first_in;
  long first_out;
  bool started;
  double defaultValue;
  int dbglev;

  void    AllocBuffer(int wsz);

#ifdef WITH_SOPHYA
  /* ---- l'interface va etre modifiee, NE PAS UTILISER
  virtual Array         doGetData(long iStart, long iEnd);
  virtual TArray<int_4> doGetFlag(long iStart, long iEnd);
  l'interface va etre modifiee, NE PAS UTILISER ---- */
#endif
  virtual void          doGetData(long i, double & val, uint_8 & flg);
   
  virtual void          doPutData(long i, double value, uint_8 flag=0);
  //  virtual void          doWontNeedBefore(long i);  plus besoin ? - Reza Mai 2002

  virtual long           nextDataAvail(long iAfter);
  virtual bool          hasSomeData();

  inline double &       dataRef(long i) { return data[i%buffsize]; }
  inline uint_8 &        flagRef(long i) { return flags[i%buffsize]; }
  inline bool           isDataDeleted(long i) 
    { return((i < next_in-buffsize-1) ? true : false); }
};


#endif
