// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi.cc,v 1.13 2003-11-14 12:34:55 aubourg Exp $

#include "toiprocessor.h"
#include "toi.h"
#include <pthread.h>

#ifdef WITH_SOPHYA
#include "pexceptions.h"
#else
#include "apexceptions.h"
#endif


TOI::TOI() {
  TOIInit();
}

TOI::TOI(string n) {
  name = n;
  TOIInit();
}

void TOI::TOIInit() {
  pthread_mutex_init(&mutex, NULL);
  //   ----- Rajouts Reza 12/3/2001
  pthread_cond_init(&condv, NULL);
  fgwaitput = fgwaitget = false;
  fgsigput = fgsigget = false;
  countwaitput = countwaitget = 0;
  //  Fin rajouts Reza 12/3/2001 ------
//  pthread_mutex_setname_np(&mutex, (name + "_toi_mutex").c_str(), 0);
  defaultValue = 0;
  producer = NULL;
  dbg = false;
  syncOldWay = true;
}

TOI::~TOI() {
  pthread_mutex_destroy(&mutex);
}

void TOI::PrintStatus(::ostream & os) const
{
  os << "TOI::PrintStatus() - Name=" << getName() << endl;
  os << " WaitStatus: Put/" ;
  if (isPutWaiting()) os << "Waiting " ;
  else os << "Running ";
  os << " PutCountWait= " << getCountWaitPut() << endl;
  os << " WaitStatus: Get/" ;
  if (isGetWaiting()) os << "Waiting " ;
  else os << "Running ";
  os << " GetCountWait= " << getCountWaitGet() << endl;
}


void TOI::setProducer(TOIProcessor* p) {
  if (producer) 
    throw DuplicateIdExc("TOI::setProducer : producer already defined");
  producer = p;
}

void TOI::addConsumer(TOIProcessor* p) {
  consumers.push_back(p);
}

long TOI::getMinSn(){
  return producer->getMinOut();
}

long TOI::getMaxSn(){
  return producer->getMaxOut();
}


// ajout vf 31/07/2002
bool TOI::checkSampleLimits(long& Min, long& Max, int pass)
{
  // propagation de la sortie du TOI vers son entree pour test des limites
  return producer->checkSampleLimits(Min, Max, pass);
}


// fin ajout vf








/* 
 RZCMV   ----- l'interface va etre modifiee, NE PAS UTILISER
#ifndef NO_SOPHYA 
Array TOI::getError(long iStart, long iEnd) {
  if (errorTOI == NULL) throw NotFoundExc("TOI::getDataError : no Error TOI");
  return errorTOI->getData(iStart, iEnd); 
}
Array TOI::getData(long iStart, long iEnd) {
  lock();
  Array a = doGetData(iStart, iEnd);
  unlock();
  if (fgsigput) { fgsigput = false; broadcast(); }
  return a;
}
TArray<int_4> TOI::getFlag(long iStart, long iEnd) {
  lock();
  TArray<int_4> a = doGetFlag(iStart, iEnd);
  unlock();
  if (fgsigput) { fgsigput = false; broadcast(); }
  return a;
}
#endif
  l'interface va etre modifiee, NE PAS UTILISER ---- 
*/


/* 
RZCMV  -------   A revoir les getError() ...
double TOI::getError(long i) {
  if (errorTOI == NULL) throw NotFoundExc("TOI::getDataError : no Error TOI");
  return errorTOI->getData(i);
}

void TOI::putDataError(long i, double value, double error, int_4 flag) {
  if (errorTOI == NULL) throw NotFoundExc("TOI::getDataError : no Error TOI");
  putData(i, value, flag);
  errorTOI->putData(i, value, flag);
}

*/

double TOI::getData(long i) { /* deprecated, overriden in toisegment */
  lock();
  uint_8 flg;
  double dat;
  doGetData(i, dat, flg);
  unlock();
  if (fgsigput) { fgsigput = false; broadcast(); }
  return dat;
}

void TOI::getData(long i, double &data, uint_8 &flag) { /* deprecated, overriden in toisegment */
  lock();
  doGetData(i, data, flag);
  unlock();
  if (fgsigput) { fgsigput = false; broadcast(); }
  return;
}

void TOI::getData(long i, int n, double* data, uint_8* flg) {
  cerr << "TOI::getData [double*] unimplemented" << endl;
  exit(-1);
}

void TOI::putData(long i, int n, double const* var, uint_8 const* flg) {
  cerr << "TOI::putData [double*] unimplemented" << endl;
  exit(-1);
}

void TOI::putData(long i, double value, uint_8 flag) { /* deprecated, overriden in toisegment */
  lock();
  doPutData(i, value, flag);
  unlock();
  if (fgsigget) { fgsigget = false; broadcast(); }
}

void TOI::waitForData(long iStart, long iEnd) { /* deprecated, overriden in toisegment */
  if (producer == NULL) throw NotFoundExc("TOI has no producer !");
    
  DataStatus s = isDataAvail(iStart, iEnd);
  if (s == DATA_OK) {
      return;
  }
  if (s == DATA_DELETED) {
      throw NotFoundExc("Data has been purged !");
  }

  producer->lock();
  while (isDataAvailNL(iStart, iEnd) == DATA_NOT_YET) {
    producer->wait();
  }
  producer->unlock();
  return;
}

void TOI::waitForData(long i) { /* deprecated, overriden in toisegment */
  waitForData(i,i);
}

void TOI::waitForAnyData() { /* deprecated, overriden in toisegment */
  if (! hasSomeData()) {
    producer->lock();
    producer->wait();
    producer->unlock();
  }
}

TOI::DataStatus TOI::isDataAvail(long i) {
  lock();
  DataStatus stat = isDataAvailNL(i);
  unlock();
  return stat;
}

TOI::DataStatus TOI::isDataAvail(long i, long j) {
  lock();
  DataStatus stat = isDataAvailNL(i,j);
  unlock();
  return stat;
}

TOI::DataStatus TOI::isDataAvailNL(long i) {
  return isDataAvailNL(i,i);
}

void TOI::wontNeedBefore(long i) { /* deprecated, overriden in toisegment */
  long j=i;
  for (vector<TOIProcessor*>::iterator k = consumers.begin();
       k != consumers.end(); k++) {
    if ((*k)->wontNeedValue < j) j = (*k)->wontNeedValue;
  }
  lock();
  doWontNeedBefore(j);
  unlock();
}

void TOI::doWontNeedBefore(long i) {
}















