// This may look like C code, but it is really -*- C++ -*-

#ifndef RAWSTREAM_H_SEEN
#define RAWSTREAM_H_SEEN

// Classe de flot brut - pour utilisation par les streams PPersist
// R. Ansari      LAL IN2P3/CNRS  11/2003

#include "machdefs.h"
#include <stdio.h>
#include <iostream>
#include <string>


namespace SOPHYA {
class RawInOutStream {
public:
                      RawInOutStream();
  virtual             ~RawInOutStream();

  virtual bool        isSeekable() const ;
  // Interface pour lecture 
  virtual int_8       tellg();
  virtual RawInOutStream& seekg(int_8, int sd = ios::beg);
  virtual RawInOutStream& read(char* s, uint_8 n);
  // Interface pour ecriture 
  virtual int_8       tellp();
  virtual RawInOutStream& seekp(int_8, int sd = ios::beg);
  virtual RawInOutStream& write(const char* s, uint_8 n);
};

// Input flow on a disk file 
class RawInFileStream : public RawInOutStream {
public:
                      RawInFileStream(const char * path);
                      RawInFileStream(string const & path);
  virtual             ~RawInFileStream();

  virtual bool        isSeekable() const ;
  // Interface pour lecture 
  virtual int_8       tellg();
  virtual RawInOutStream& seekg(int_8, int sd = ios::beg);
  virtual RawInOutStream& read(char* s, uint_8 n); 

  inline  std::string     getFileName() const { return _filename; }
protected:
  FILE * fip;
  std::string _filename;
};

// Output flow on a disk file 
class RawOutFileStream : public RawInOutStream {
public:
                      RawOutFileStream(const char * path);
                      RawOutFileStream(string const & path);
  virtual             ~RawOutFileStream();

  virtual bool        isSeekable() const ;
  // Interface pour ecriture 
  virtual int_8       tellp();
  virtual RawInOutStream& seekp(int_8 pos, int sd = ios::beg);
  virtual RawInOutStream& write(const char* s, uint_8 n);

  inline  std::string     getFileName() const { return _filename; }
protected:
  FILE * fip;
  std::string _filename;  
};


} // namespace SOPHYA

#endif
